/*
 * s5deck.h
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_S5DECK_H__
#define __LIBx1f4_S5DECK_H__

#include <errors.h>
#include <s5xx-names.h>

/*
 * attribute bit definitions
 */
#define X1f4_S5DECK_TRANS_MASK		(1u << 0x00)

/*
 * error definitions
 */
#define X1f4_S5DECK_FREE_ERROR		LIBx1f4L2_FREE_ERROR
#define X1f4_S5DECK_LINK_ERROR		LIBx1f4L2_LINK_ERROR
#define X1f4_S5DECK_MODE_ERROR		LIBx1f4L2_MODE_ERROR

/*
 * error definitions (continued)
 */
#define X1f4_S5DECK_EVER_MATCH		LIBx1f4L2_EVER_MATCH

typedef struct x1f4_s5deck_type {
    void *trans;
} x1f4_s5deck_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_case_s5deck(void *);
extern int x1f4_copy_s5deck(void **, void *);
extern int x1f4_fast_s5deck(void *, unsigned, struct x1f4_s5deck_type *);
extern int x1f4_fill_s5deck(void *, void *);
extern int x1f4_find_s5path(void *, const char *, unsigned, const void **);
extern int x1f4_fini_s5deck(void **);
extern int x1f4_flat_s5deck(void *);
extern int x1f4_init_s5deck(void **, unsigned, struct x1f4_s5deck_type *);
extern int x1f4_lime_s5deck(void *, void *, int (*) (void *, const void *));
extern int x1f4_note_s5deck
    (void *, void *, int (*) (void *, const char *, unsigned));
extern int x1f4_pass_s5path(void *, const char *, unsigned);
extern int x1f4_pick_s5path(void *, const char *, unsigned, const void ***);
extern int x1f4_post_s5path(void *, const char *, unsigned, const void *);
extern int x1f4_span_s5deck
    (void *, void *, int (*) (void *, const void *, const char *, unsigned));

#endif				/* __LIBx1f4_S5DECK_H__ */
