/*
 * qsce.u.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
x1f4_lead_qsrate(void *qsrate, void **peek)
{
    int status;

    if (!qsrate(qsrate)->link_a.fplist.size) {
	status = DECK_ERROR;
    } else {
	unsigned rate;
	void *node;

	node = qsrate(qsrate)->link_a.fplist.fpnode;

	status = 0;

	rate = qsrate(qsrate)->link_a.fplist.rate;

	if (rate) {
	    struct fpnode_type *fpnode_data;

	    fpnode_data = node;

	    if (1) {
		unsigned *cell, half;

		half = qsrate(qsrate)->link_a.fplist.lock;

		cell = &fpnode_data->call;

		while (3 < half) {
		    unsigned *call, sail;

		    sail = sizeof(struct fpnode_type) << half;

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    if (*call) {
		    } else {
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    if (*call) {
		    } else {
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    if (*call) {
		    } else {
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    if (*call) {
		    } else {
			cell = call;
		    }

		    half -= 4;
		}
		while (half) {
		    unsigned *call;

		    half--;

		    call = (void *)
			((char *) cell + (sizeof(struct fpnode_type) << half));

		    if (*call) {
		    } else {
			cell = call;
		    }
		}

		fpnode_data = (void *)
		    ((char *) cell - offsetof(struct fpnode_type, call));

		fpnode_data = fpnode_data->star;

		rate--;
	    }

	    while (rate) {
		fpnode_data = fpnode_data->star;
		rate--;
	    }

	    node = fpnode_data;
	}

	*peek = node;
    }

    return status;
}
