/*
 * qsce.s.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>
#include <string.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
x1f4_mind_qsrate(void *qsrate)
{
    int status;
    unsigned count;

    count = qsrate(qsrate)->link_a.fplist.size;

    if (!count) {
	status = DECK_ERROR;
    } else {
	unsigned rate;
	void *node;

	qsrate(qsrate)->link_a.fplist.size = count - 1;

	node = qsrate(qsrate)->link_a.fplist.fpnode;

	status = 0;

	rate = qsrate(qsrate)->link_a.fplist.rate;

	do {
	    if (rate) {
#if __DELAY_MERGE__
		struct dhmiss_type dhmiss;
#endif				/* __DELAY_MERGE__ */
		struct fpnode_type *fpnode_data;
		unsigned *cell;
		unsigned *near;

#if __DELAY_MERGE__
		dhmiss.hook = NULL;
#endif				/* __DELAY_MERGE__ */

		near = &qsrate(qsrate)->link_a.fplist.node;

		if (1) {
		    unsigned lock, miss;

		    lock = qsrate(qsrate)->link_a.fplist.lock;

		    miss = 1 << lock >> 1;

		    if (1) {
			unsigned half;

			fpnode_data = node;

			half = lock;

			cell = &fpnode_data->call;

			while (3 < half) {
			    unsigned *call, news, sail;

			    sail = sizeof(struct fpnode_type) << half;

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    news = *call;
			    if (news) {
				*call = news - 1;
			    } else {
				cell = call;
			    }

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    news = *call;
			    if (news) {
				*call = news - 1;
			    } else {
				cell = call;
			    }

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    news = *call;
			    if (news) {
				*call = news - 1;
			    } else {
				cell = call;
			    }

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    news = *call;
			    if (news) {
				*call = news - 1;
			    } else {
				cell = call;
			    }

			    half -= 4;
			}
			while (half) {
			    unsigned *call, news;

			    half--;

			    call = (void *)
				((char *) cell
				 + (sizeof(struct fpnode_type) << half));

			    news = *call;
			    if (news) {
				*call = news - 1;
			    } else {
				cell = call;
			    }
			}

			fpnode_data = (void *)
			    ((char *) cell
			     - offsetof(struct fpnode_type, call));

			rate--;
		    }

		    while (rate) {
			unsigned half;

			if (1) {
			    unsigned *fail;

			    fail = &fpnode_data->node;
			    if (*fail ^ miss) {
				near = fail;

				node = fpnode_data->star;

#if __DELAY_MERGE__
				dhmiss.hook = NULL;
#endif				/* __DELAY_MERGE__ */
			    } else {
#if __DELAY_MERGE__
				if (dhmiss.hook) {
				    unsigned call;

				    call = fpnode_data
					- (struct fpnode_type *) node;
				    do {
					if (call) {
					    if ((fpnode_data - 2)->node
						^ miss) {
						dhmiss.hook = NULL;
						break;
					    }
					}
					call += 2;
					if (call ^ (miss << 1)) {
					    if ((fpnode_data + 2)->node
						^ miss) {
						dhmiss.hook = NULL;
					    }
					}
				    } while (0);
				}
				if (dhmiss.hook) {
# if __STAMP_MERGE__
				    struct fpnode_type *fpnode_slip;

				    fpnode_slip = node;
				    fpnode_slip->call =
					fpnode_data - fpnode_slip;
# endif				/* __STAMP_MERGE__ */
				} else {
				    dhmiss.hook = node;
				    dhmiss.late = rate;
				    dhmiss.meta = near;
				    if (1) {
# if __STAMP_MERGE__
# else
					dhmiss.black = 0;
# endif				/* __STAMP_MERGE__ */
					if (1) {
					    dhmiss.side = fpnode_data;
					}
				    }
				}

				near = fail;

				node = fpnode_data->star;
#else
				int excess;
				unsigned index = 0;

				excess = _libx1f4l2_away_qsrate
				    (qsrate, near, node, fpnode_data, &index,
				     &near, &node);
				if (excess) {
				    if (status) {
				    } else {
					status = excess;
				    }
				}
#endif				/* __DELAY_MERGE__ */
			    }
			}

			fpnode_data = node;

			half = lock;

			cell = &fpnode_data->call;

			while (3 < half) {
			    unsigned *call, sail;

			    sail = sizeof(struct fpnode_type) << half;

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    (*call)--;

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    (*call)--;

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    (*call)--;

			    sail >>= 1;
			    call = (void *) ((char *) cell + sail);

			    (*call)--;

			    half -= 4;
			}
			while (half) {
			    unsigned *call;

			    half--;

			    call = (void *)
				((char *) cell
				 + (sizeof(struct fpnode_type) << half));

			    (*call)--;
			}

			fpnode_data = (void *)
			    ((char *) cell
			     - offsetof(struct fpnode_type, call));

			rate--;
		    }
		}

		if (fpnode_data->node
		    == qsrate(qsrate)->link_a.fplist.line >> 1) {
		    int excess;

#if __DELAY_MERGE__
		    excess = _libx1f4l2_long_qsrate
			(qsrate, near, node, fpnode_data, 0, &dhmiss);
#else
		    excess = _libx1f4l2_long_qsrate
			(qsrate, near, node, fpnode_data, 0);
#endif				/* __DELAY_MERGE__ */
		    if (1) {
			if (status) {
			} else {
			    status = excess;
			}

			break;
		    }
		}

		count = fpnode_data->node;

		fpnode_data->node = count - 1;

		node = fpnode_data->star;
	    }

	    count--;
 	    if (count) {
		unsigned mall;

		mall = qsrate(qsrate)->link_a.fplist.mall;

		memmove(node, (char *) node + mall, count * mall);
	    } else {
	    }
	} while (0);
    }

    return status;
}
