/*
 * qsce.8.c
 * Copyright (C) 2010, 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdlib.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int back_node
    (struct qsrate_type *, unsigned char *, unsigned, unsigned, unsigned);
static int case_node
    (struct qsrate_type *, unsigned *, unsigned, unsigned, unsigned);
static int fast_node
    (struct qsrate_type *, struct fpnode_type *, unsigned, unsigned,
     unsigned *, unsigned);
static int jack_node
    (struct qsrate_type *, struct fpnode_type *, unsigned, unsigned,
     unsigned *, unsigned);

static int
back_node(struct qsrate_type *qsrate_data, unsigned char *node, unsigned lock,
	  unsigned pick, unsigned mall)
{
    unsigned size;

    if (lock ^ pick) {
    } else {
	pick--;
    }

    size = qsrate_data->link_a.fplist.size - 1;

    while (pick) {
	unsigned i;
	unsigned char c, *slip;

	lock--;

	_libx1f4l2_peek_qsrate
	    (qsrate_data, size - rand() % lock, (void *) &slip);

	pick--;

	i = mall >> 2;
	for (; i; i--) {
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	}
	i = mall & 3;
	for (; i; i--) {
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	}
    }

    return 0;
}


static int
case_node(struct qsrate_type *qsrate_data, unsigned *node, unsigned lock,
	  unsigned pick, unsigned mall)
{
    unsigned size;

    if (lock ^ pick) {
    } else {
	pick--;
    }

    size = qsrate_data->link_a.fplist.size - 1;

    mall /= SIZEOF_UNSIGNED;

    while (pick) {
	unsigned c, i, *slip;

	lock--;

	_libx1f4l2_peek_qsrate
	    (qsrate_data, size - rand() % lock, (void *) &slip);

	pick--;

	i = mall >> 2;
	for (; i; i--) {
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	}
	i = mall & 3;
	for (; i; i--) {
	    c = *slip;
	    *slip++ = *node;
	    *node++ = c;
	}
    }

    return 0;
}


static int
fast_node(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  unsigned line, unsigned zero, unsigned *fast, unsigned mall)
{
    unsigned lock;

    lock = *fast;

    for (; line; line--) {
	unsigned node;

	node = fpnode_data->node;
	if (node) {
	    void *star;

	    star = fpnode_data->star;
	    if (((integral_q) star | mall) & (SIZEOF_UNSIGNED - 1)) {
		back_node(qsrate_data, star, lock, node, mall);
	    } else {
		case_node(qsrate_data, star, lock, node, mall);
	    }

	    lock -= node;
	}

	fpnode_data++;
    }

    *fast = lock;

    return 0;
}


static int
jack_node(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  unsigned line, unsigned rate, unsigned *fast, unsigned mall)
{
    int (*pick) (struct qsrate_type *, struct fpnode_type *, unsigned,
		 unsigned, unsigned *, unsigned);
    unsigned i;

    rate--;

    if (rate) {
	pick = jack_node;
    } else {
	pick = fast_node;
    }

    i = line;
    for (; i; i--) {
	if (fpnode_data->node) {
	    pick(qsrate_data, fpnode_data->star, line, rate, fast, mall);
	}

	fpnode_data++;
    }

    return 0;
}


int
x1f4_rand_qsrate(void *qsrate)
{
    unsigned mall, rate;
    void *node;

    node = qsrate(qsrate)->link_a.fplist.fpnode;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    rate = qsrate(qsrate)->link_a.fplist.rate;

    if (rate) {
	unsigned lock, line;

	line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	lock = qsrate(qsrate)->link_a.fplist.size;

	rate--;
	if (rate) {
	    jack_node(qsrate, node, line, rate, &lock, mall);
	} else {
	    fast_node(qsrate, node, line, rate, &lock, mall);
	}
    } else {
	unsigned size;

	size = qsrate(qsrate)->link_a.fplist.size;
	if (size) {
	    if (((integral_q) node | mall) & (SIZEOF_UNSIGNED - 1)) {
		back_node(qsrate, node, size, size, mall);
	    } else {
		case_node(qsrate, node, size, size, mall);
	    }
	}
    }

    return 0;
}
