/*
 * qscc.y.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int back_rate
    (struct qsrate_type *, struct fpnode_type *, unsigned, unsigned);
static int flat_rate(struct qsrate_type *, void *, unsigned, unsigned);

static int
back_rate(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  unsigned rate, unsigned line)
{
    int excess, status = 0;
    unsigned i;

    i = line;
    for (; i; i--) {
	if (fpnode_data->node) {
	    excess = flat_rate(qsrate_data, fpnode_data->star, rate, line);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }
	}

	fpnode_data++;
    }

    return status;
}


static int
flat_rate(struct qsrate_type *qsrate_data, void *node, unsigned rate,
	  unsigned line)
{
    int excess, status;

    if (rate) {
	status = back_rate(qsrate_data, node, rate - 1, line);
    } else {
	status = 0;
    }

    excess = qsrate_data->link_m.free(qsrate_data->link_m.data, node);
    if (excess) {
	if (status) {
	} else {
	    status = FREE_ERROR;
	}
    }

    return status;
}


int
_libx1f4l2_ceil_qsrate(void *qsrate)
{
    int excess, status;
    unsigned rate;
    void *land;

    rate = qsrate(qsrate)->link_a.fplist.rate;
    if (rate) {
	void *node;

	node = qsrate(qsrate)->link_a.fplist.fpnode;
	status = back_rate
	    (qsrate, node, rate - 1, 1 << qsrate(qsrate)->link_a.fplist.lock);
    } else {
	status = 0;
    }

    land = qsrate(qsrate)->link_e.fplink_text;
    if (land) {
	excess = qsrate(qsrate)->link_m.free
	    (qsrate(qsrate)->link_m.data, land);
	if (excess) {
	    if (status) {
	    } else {
		status = FREE_ERROR;
	    }
	}
    }

    land = qsrate(qsrate)->link_e.fplink_data;
    while (land) {
	struct fplink_type *fplink_data;

	fplink_data = ((struct fplink_type *) land)->fplink_data;

	excess = qsrate(qsrate)->link_m.free
	    (qsrate(qsrate)->link_m.data, land);
	if (excess) {
	    if (status) {
	    } else {
		status = FREE_ERROR;
	    }
	}

	land = fplink_data;
    }

    return status;
}
