/*
 * qscc.x.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_mail_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned call,
		       struct fpnode_type *fpnode_post)
{
    int status;

    status = qsrate(qsrate)->link_m.free
	(qsrate(qsrate)->link_m.data, fpnode_post->star);
    if (status) {
	status = FREE_ERROR;
    }

    if (1) {
	if (*near == 2) {
	    int excess;
	    unsigned mall;
	    void *node, *star;

	    node = qsrate(qsrate)->link_a.fplist.fpnode;

	    star = fpnode_data->star;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }

	    node = qsrate(qsrate)->link_e.fplink_text;

	    qsrate(qsrate)->link_e.fplink_text = NULL;

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    if (qsrate(qsrate)->link_m.mode
		(qsrate(qsrate)->link_m.data, &star,
		 qsrate(qsrate)->link_a.fplist.line * 3 * mall >> 1)) {
		void *sail;

		memcpy(node, star, mall * fpnode_data->node);

		sail = node;
		node = star;
		star = sail;
	    } else {
	    }

	    qsrate(qsrate)->link_a.fplist.fpnode = star;
	    qsrate(qsrate)->link_a.fplist.node =
		qsrate(qsrate)->link_a.fplist.size;
	    qsrate(qsrate)->link_a.fplist.rate = 0;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }
	} else {
	    unsigned line, post, text;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    text = qsrate(qsrate)->link_a.fplist.line >> 1;

	    (*near)--;

	    post = fpnode_post - fpnode_line;

	    post++;
	    while (post < line) {
		(fpnode_line + post)->call -= text;
		post += post & ~(post - 1);
	    }

	    call++;
	    do {
		(fpnode_line + call)->call += text;
		call += call & ~(call - 1);
	    } while (call < line);
	}
    }

    return status;
}
