/*
 * qscc.w.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static void push_last(struct fpnode_type *, unsigned, unsigned, unsigned,
		      unsigned *, struct fpnode_type **);
static void push_post(struct fpnode_type *, unsigned, unsigned, unsigned,
		      unsigned *, struct fpnode_type **);
static void rate_node(struct fpnode_type *, unsigned, unsigned, unsigned);

static void
push_last(struct fpnode_type *fpnode_data, unsigned cell, unsigned last,
	  unsigned lock, unsigned *index, struct fpnode_type **fpnode)
{
    unsigned e, node, q, w, x;
    void *star = NULL;

    fpnode_data += cell;

    x = cell;

    node = 1 << lock >> 1;

    w = ((struct fpnode_type *) fpnode_data->star)[node].call;
    if (*index < w) {
#if __DELAY_SPLIT__
#else
	w++;
#endif				/* __DELAY_SPLIT__ */
	*fpnode = fpnode_data - 1;
    } else {
	*index = *index - w;
    }

    fpnode_data->node = node;

    if (1) {
	q = fpnode_data->call;
    } else {
    }

    {
	if (x & 1) {
	} else {
	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);
	}

	{
	    fpnode_data->call += w;
	}
    }

    last++;
    last = x - last;
    if (last) {
	unsigned b, i;

	if (x & 1) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    x--;

	    w = q;

	    q = fpnode_data->call;

	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    b = e;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);

	    fpnode_data->call += w;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    last--;
	} else {
	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    b = e;
	}

	i = last >> 1;
	for (; i; i--) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    x--;

	    w = q;

	    q = fpnode_data->call;

	    fpnode_data++;

	    e = b;

	    do {
		w -= (fpnode_data - e)->call;
		e >>= 1;
	    } while (e);

	    fpnode_data--;

	    fpnode_data->call += w;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;

	    fpnode_data--;

	    x--;

	    w = q;

	    q = fpnode_data->call;

	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    b = e;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);

	    fpnode_data->call += w;

	    node = fpnode_data->node;
	    star = fpnode_data->star;
	    fpnode_data->node = Node;
	    fpnode_data->star = Star;
	}

	if (last & 1) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    x--;

	    w = q;

	    q = fpnode_data->call;

	    fpnode_data++;

	    e = b;

	    do {
		w -= (fpnode_data - e)->call;
		e >>= 1;
	    } while (e);

	    fpnode_data--;

	    fpnode_data->call += w;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;
	}
    }

    {
	fpnode_data--;

	{
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	}
    }
}


static void
push_post(struct fpnode_type *fpnode_data, unsigned cell, unsigned post,
	  unsigned lock, unsigned *index, struct fpnode_type **fpnode)
{
    unsigned e, l, node, w, x;
    void *star = NULL;

    fpnode_data += cell;

    x = cell;

    if (x & 1) {
	fpnode_data++;

	w = fpnode_data->call;

	if (1) {
	    e = ~(x + 1);

	    l = 1;
	    while (e & 1) {
		w -= (fpnode_data - l)->call;
		l <<= 1;
		e >>= 1;
	    }
	}

	fpnode_data--;
    } else {
	w = (fpnode_data + 1)->call;
    }

    node = 1 << lock >> 1;

    e = ((struct fpnode_type *) fpnode_data->star)[node].call;
    w -= e;
    if (*index < e) {
#if __DELAY_SPLIT__
#else
	w--;
#endif				/* __DELAY_SPLIT__ */
    } else {
	*index = *index - e;
	*fpnode = fpnode_data + 1;
    }

    fpnode_data->node = node;

    {
	fpnode_data++;

	if (x & 1) {
	    e = ~x;
	    e = e ^ (e & (e - 1));
	    e >>= 1;

	    do {
		(fpnode_data + e)->call += w;
		e >>= 1;
	    } while (e);
	}
    }

    post--;
    post -= x;
    if (post) {
	unsigned i;

	if (x & 1) {
	    unsigned Node, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = fpnode_data->call;

	    v -= w;

	    w = v;

	    post--;
	}

	i = post >> 1;
	for (; i; i--) {
	    unsigned Node, b, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = fpnode_data->call;

	    e = x;

	    x++;

	    e &= x;
	    e ^= x;
	    e >>= 1;

	    b = e;

	    do {
		v -= (fpnode_data - e)->call;
		e >>= 1;
	    } while (e);

	    v -= w;

	    e = b;

	    do {
		(fpnode_data + e)->call += v;
		e >>= 1;
	    } while (e);

	    node = fpnode_data->node;
	    star = fpnode_data->star;
	    fpnode_data->node = Node;
	    fpnode_data->star = Star;

	    fpnode_data->call -= v;

	    fpnode_data++;

	    w = fpnode_data->call;

	    w -= v;
	}

	/*
	 * not getting into the next too often
	 */
	if (post & 1) {
	    unsigned Node, b, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = fpnode_data->call;

	    e = x + 1;
	    e = e ^ (e & x);
	    e >>= 1;

	    b = e;

	    do {
		v -= (fpnode_data - e)->call;
		e >>= 1;
	    } while (e);

	    v -= w;

	    e = b;

	    do {
		(fpnode_data + e)->call += v;
		e >>= 1;
	    } while (e);

	    w = v;
	}
    }

    {
	fpnode_data->call -= w;

	{
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	}
    }
}


static void
rate_node(struct fpnode_type *fpnode_data, unsigned line, unsigned mail,
	  unsigned tail)
{
    unsigned i;

    fpnode_data += line << 1;

    if (tail) {
	fpnode_data--;

	fpnode_data->call = tail;
	fpnode_data->node = 0;
    } else {
	unsigned call, j, news, s = 1;

	call = mail;
	news = call;
	j = ~line;
	while (j & 1) {
	    s <<= 1;
	    news -= (fpnode_data - s)->call;
	    j >>= 1;
	}

	fpnode_data--;

	fpnode_data->call = news;
	fpnode_data->node = 0;
    }
    for (i = line - 1; i; i--) {
	unsigned call, j, news, s = 1;

	fpnode_data--;

	call = fpnode_data->call;
	news = call;
	j = ~i;
	while (j & 1) {
	    s <<= 1;
	    news -= (fpnode_data - s)->call;
	    j >>= 1;
	}

	fpnode_data--;

	fpnode_data->call = news;
	fpnode_data->node = 0;
    }
}


int
_libx1f4l2_sand_qsrate(void *qsrate, struct fpnode_type *fpnode_call,
		       struct fpnode_type **fpnode, unsigned *index,
		       unsigned rate)
{
    int status;
    struct fpnode_type *fpnode_data, *fpnode_line;
    unsigned beta = 0, cell, last = ~0, lock, post = ~0, tail = 0;
    void *side;

    lock = qsrate(qsrate)->link_a.fplist.lock;

    status = qsrate(qsrate)->link_m.link
	(qsrate(qsrate)->link_m.data, &side,
	 sizeof(struct fpnode_type) << lock);
    if (status) {
	status = _libx1f4l2_rack_qsrate(qsrate, 1, &side);
    }

    fpnode_data = *fpnode;

    if (fpnode_call) {
	fpnode_call->node++;
	fpnode_line = fpnode_call->star;
    } else {
	qsrate(qsrate)->link_a.fplist.node++;
	fpnode_line = qsrate(qsrate)->link_a.fplist.fpnode;
    }

    fpnode_data++;

    cell = fpnode_data - fpnode_line;

    if (cell ^ 1 << lock) {
	unsigned e;

	beta = fpnode_data->call;

	e = cell;
	e--;
	e &= cell;
	e ^= cell;
	e >>= 1;

	while (e) {
	    beta -= (fpnode_data - e)->call;
	    e >>= 1;
	}

	fpnode_data--;
    } else {
	struct fpnode_type *fpnode_text;

	fpnode_data--;

	fpnode_text = fpnode_data->star;

	fpnode_text += 1 << lock;
	fpnode_text--;

	rate--;
	while (rate) {
	    unsigned half;

	    rate--;

	    fpnode_text = fpnode_text->star;

	    half = 1 << lock >> 1;
	    while (half) {
		fpnode_text += half;
		tail += fpnode_text->call;
		half >>= 1;
	    }

	    if (fpnode_text->node) {
	    } else {
		if (1) {
		    break;
		}
	    }
	}

	tail += fpnode_text->node;
    }

    cell--;

    do {
	if (fpnode_call) {
	    struct fpnode_type *fpnode_last, *fpnode_post;
	    unsigned line, mind, slip, text;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_last = fpnode_line + cell;
	    fpnode_post = fpnode_last;

	    mind = cell >> 1;
	    slip = (line - cell) >> 1;

	    if (cell & 1) {
		fpnode_last -= 2;
		fpnode_post += 2;
	    } else {
		fpnode_last -= 1;
		fpnode_post += 1;
	    }

	    text = mind < slip ? mind : slip;
	    while (text) {
		if (fpnode_post->node) {
		    fpnode_post += 2;
		} else {
		    post = fpnode_post - fpnode_line;
		    if (1) {
			break;
		    }
		}
		if (fpnode_last->node) {
		    fpnode_last -= 2;
		} else {
		    last = fpnode_last - fpnode_line;
		    if (1) {
			break;
		    }
		}

		text--;
	    }

	    if (text) {
	    } else {
		if (mind < slip) {
		    slip -= mind;
		    for (; slip; slip--) {
			if (fpnode_post->node) {
			    fpnode_post += 2;
			} else {
			    post = fpnode_post - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    mind -= slip;
		    for (; mind; mind--) {
			if (fpnode_last->node) {
			    fpnode_last -= 2;
			} else {
			    last = fpnode_last - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	} else {
	    struct fpnode_type *fpnode_last, *fpnode_post;
	    unsigned line, mind, slip, text;

	    if (cell & 3) {
	    } else {
		if (_libx1f4l2_sail_qsrate
		    (qsrate, &fpnode_line, cell, side, index, fpnode)) {
		    break;
		}
	    }

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_last = fpnode_line + cell;
	    fpnode_post = fpnode_last;

	    mind = cell;
	    slip = line - cell - 1;

	    if (0) {
	    } else {
		fpnode_last -= 1;
		fpnode_post += 1;
	    }

	    text = mind < slip ? mind : slip;
	    while (text) {
		if (fpnode_post->node) {
		    fpnode_post++;
		} else {
		    post = fpnode_post - fpnode_line;
		    if (1) {
			break;
		    }
		}
		if (fpnode_last->node) {
		    fpnode_last--;
		} else {
		    last = fpnode_last - fpnode_line;
		    if (1) {
			break;
		    }
		}

		text--;
	    }

	    if (text) {
	    } else {
		if (mind < slip) {
		    slip -= mind;
		    for (; slip; slip--) {
			if (fpnode_post->node) {
			    fpnode_post++;
			} else {
			    post = fpnode_post - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    mind -= slip;
		    for (; mind; mind--) {
			if (fpnode_last->node) {
			    fpnode_last--;
			} else {
			    last = fpnode_last - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	}

	if (~last) {
	    void *sale;

	    push_last(fpnode_line, cell, last, lock, index, fpnode);

	    fpnode_line = fpnode_data;

	    sale = fpnode_data->star;
	    fpnode_data->star = side;

	    fpnode_data--;

	    fpnode_data->star = sale;
	} else {
	    push_post(fpnode_line, cell, post, lock, index, fpnode);

	    fpnode_line = fpnode_data + 1;

	    fpnode_line->star = side;
	}
    } while (0);

    {
	struct fpnode_type *fpnode_link, *fpnode_text;
	unsigned half, i, miss;
	void *sale;

	sale = fpnode_data->star;

	side = fpnode_line->star;

	fpnode_link = side;

	fpnode_text = sale;

	half = 1 << lock >> 1;

	fpnode_text += half;

	miss = fpnode_text->call;

	i = half;
	for (; i; i--) {
	    *fpnode_link = *fpnode_text++;
	    fpnode_link += 2;
	}

	if (beta) {
#if __DELAY_SPLIT__
	    rate_node(side, half, beta - miss, 0);
#else
	    rate_node(side, half, beta - miss - 1, 0);
#endif				/* __DELAY_SPLIT__ */
	} else {
	    rate_node(side, half, 0, tail);
	}

	fpnode_link = sale;

	fpnode_link += half;

	i = half;
	for (; i; i--) {
	    fpnode_text -= 2;
	    *fpnode_text = *--fpnode_link;
	}

	rate_node(sale, half, miss, 0);
    }

    return status;
}
