/*
 * qscc.p.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static void push_last(struct fpnode_type *, unsigned, unsigned, unsigned);
static void push_post(struct fpnode_type *, unsigned, unsigned, unsigned);

static void
push_last(struct fpnode_type *fpnode_data, unsigned flat, unsigned cell,
	  unsigned last)
{
    unsigned e, node, w, x;
    void *star = NULL;

    fpnode_data += cell;

    x = cell;

    node = flat;

    w = flat;

    fpnode_data->node = w;

    {
	if (x & 1) {
	} else {
	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);
	}

	{
	    fpnode_data->call += w;
	}
    }

    last++;
    last = x - last;
    if (last) {
	unsigned i;

	if (x & 1) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    x--;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    w = node;

	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);

	    fpnode_data->call += w;

	    last--;
	} else {
	}

	i = last >> 1;
	for (; i; i--) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    x--;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;

	    w = Node;

	    fpnode_data->call += w;

	    fpnode_data--;

	    x--;

	    node = fpnode_data->node;
	    star = fpnode_data->star;
	    fpnode_data->node = Node;
	    fpnode_data->star = Star;

	    w = node;

	    e = x;
	    e--;
	    e &= x;
	    e ^= x;
	    e >>= 1;

	    do {
		(fpnode_data + e)->call -= w;
		e >>= 1;
	    } while (e);

	    fpnode_data->call += w;
	}

	if (last & 1) {
	    unsigned Node;
	    void *Star;

	    fpnode_data--;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    w = Node;

	    fpnode_data->call += w;
	}
    }

    {
	fpnode_data--;

	{
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	}
    }
}


static void
push_post(struct fpnode_type *fpnode_data, unsigned flat, unsigned cell,
	  unsigned post)
{
    unsigned e, node, w, x;
    void *star = NULL;

    fpnode_data += cell;

    x = cell;

    node = flat;

    w = flat;

    fpnode_data->node = w;

    {
	fpnode_data++;

	if (x & 1) {
	    e = ~x;
	    e = e ^ (e & (e - 1));
	    e >>= 1;

	    do {
		(fpnode_data + e)->call += w;
		e >>= 1;
	    } while (e);
	}
    }

    post--;
    post -= x;
    if (post) {
	unsigned i;

	if (x & 1) {
	    unsigned Node, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = node;

	    w = v;

	    post--;
	}

	i = post >> 1;
	for (; i; i--) {
	    unsigned Node, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = Node;

	    e = x;

	    x++;

	    e &= x;
	    e ^= x;
	    e >>= 1;

	    do {
		(fpnode_data + e)->call += v;
		e >>= 1;
	    } while (e);

	    node = fpnode_data->node;
	    star = fpnode_data->star;
	    fpnode_data->node = Node;
	    fpnode_data->star = Star;

	    fpnode_data->call -= v;

	    fpnode_data++;

	    w = node;
	}

	/*
	 * not getting into the next too often
	 */
	if (post & 1) {
	    unsigned Node, v;
	    void *Star;

	    x++;

	    Node = fpnode_data->node;
	    Star = fpnode_data->star;
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	    node = Node;
	    star = Star;

	    fpnode_data->call -= w;

	    fpnode_data++;

	    v = Node;

	    e = x + 1;
	    e = e ^ (e & x);
	    e >>= 1;

	    do {
		(fpnode_data + e)->call += v;
		e >>= 1;
	    } while (e);

	    w = v;
	}
    }

    {
	fpnode_data->call -= w;

	{
	    fpnode_data->node = node;
	    fpnode_data->star = star;
	}
    }
}


int
_libx1f4l2_mold_qsrate(void *qsrate, struct fpnode_type *fpnode_call,
		       struct fpnode_type **fpnode, unsigned *index)
{
    int status;
    struct fpnode_type *fpnode_data, *fpnode_line;
    unsigned flat, mall, seek;
    void *side;

    flat = qsrate(qsrate)->link_a.fplist.line;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    status = qsrate(qsrate)->link_m.link
	(qsrate(qsrate)->link_m.data, &side, flat * mall);
    if (status) {
	status = _libx1f4l2_rack_qsrate(qsrate, 0, &side);
    }

    fpnode_data = *fpnode;

    do {
	unsigned cell, last = ~0, post = ~0;

	if (fpnode_call) {
	    struct fpnode_type *fpnode_last, *fpnode_post;
	    unsigned line, mind, slip, text;

	    seek = 1;
	    fpnode_call->node++;
	    fpnode_line = fpnode_call->star;

	    cell = fpnode_data - fpnode_line;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_last = fpnode_line + cell;
	    fpnode_post = fpnode_last;

	    mind = cell >> 1;
	    slip = (line - cell) >> 1;

	    if (cell & 1) {
		fpnode_last -= 2;
		fpnode_post += 2;
	    } else {
		fpnode_last -= 1;
		fpnode_post += 1;
	    }

	    text = mind < slip ? mind : slip;
	    while (text) {
		if (fpnode_post->node) {
		    fpnode_post += 2;
		} else {
		    post = fpnode_post - fpnode_line;
		    if (1) {
			break;
		    }
		}
		if (fpnode_last->node) {
		    fpnode_last -= 2;
		} else {
		    last = fpnode_last - fpnode_line;
		    if (1) {
			break;
		    }
		}

		text--;
	    }

	    if (text) {
	    } else {
		if (mind < slip) {
		    slip -= mind;
		    for (; slip; slip--) {
			if (fpnode_post->node) {
			    fpnode_post += 2;
			} else {
			    post = fpnode_post - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    mind -= slip;
		    for (; mind; mind--) {
			if (fpnode_last->node) {
			    fpnode_last -= 2;
			} else {
			    last = fpnode_last - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	} else {
	    struct fpnode_type *fpnode_last, *fpnode_post;
	    unsigned line, mind, slip, text;

	    seek = 0;
	    qsrate(qsrate)->link_a.fplist.node++;
	    fpnode_line = qsrate(qsrate)->link_a.fplist.fpnode;

	    cell = fpnode_data - fpnode_line;

	    if (cell & 3) {
	    } else {
		if (_libx1f4l2_true_qsrate
		    (qsrate, fpnode_line, side, fpnode, index)) {
		    break;
		}
	    }

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_last = fpnode_line + cell;
	    fpnode_post = fpnode_last;

	    mind = cell;
	    slip = line - cell - 1;

	    if (0) {
	    } else {
		fpnode_last -= 1;
		fpnode_post += 1;
	    }

	    text = mind < slip ? mind : slip;
	    while (text) {
		if (fpnode_post->node) {
		    fpnode_post++;
		} else {
		    post = fpnode_post - fpnode_line;
		    if (1) {
			break;
		    }
		}
		if (fpnode_last->node) {
		    fpnode_last--;
		} else {
		    last = fpnode_last - fpnode_line;
		    if (1) {
			break;
		    }
		}

		text--;
	    }

	    if (text) {
	    } else {
		if (mind < slip) {
		    slip -= mind;
		    for (; slip; slip--) {
			if (fpnode_post->node) {
			    fpnode_post++;
			} else {
			    post = fpnode_post - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    mind -= slip;
		    for (; mind; mind--) {
			if (fpnode_last->node) {
			    fpnode_last--;
			} else {
			    last = fpnode_last - fpnode_line;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	}

	flat >>= 1;

	if (~last) {
	    unsigned half, pick;
	    void *sale;

	    push_last(fpnode_line, flat, cell, last);

	    sale = fpnode_data->star;
	    fpnode_data->star = side;

	    fpnode_data--;

	    fpnode_data->star = sale;

	    half = flat * mall;

	    pick = *index;
	    if (pick < flat) {
		memcpy(side, (char *) sale + half - mall, half + mall);
		*fpnode = fpnode_data;
		(fpnode_data - 0)->node--;
		(fpnode_data + 1)->node++;
	    } else {
		memcpy(side, (char *) sale + half, half);
		*index = pick - flat;
	    }
	} else {
	    unsigned half, pick;

	    if (post - cell == seek) {
		fpnode_data->node = flat;

		fpnode_data++;

		fpnode_data->call -= flat;
		fpnode_data->node = flat;
	    } else {
		push_post(fpnode_line, flat, cell, post);

		fpnode_data++;
	    }

	    fpnode_data->star = side;

	    half = flat * mall;

	    flat++;

	    pick = *index;
	    if (pick < flat) {
		memcpy(side, (char *) (fpnode_data - 1)->star + half, half);
	    } else {
		memcpy(side, (char *) (fpnode_data - 1)->star + half + mall,
		       half - mall);
		*index = pick - flat;
		*fpnode = fpnode_data;
		(fpnode_data - 0)->node--;
		(fpnode_data - 1)->node++;
	    }
	}
    } while (0);

    return status;
}
