/*
 * qscc.o.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>
#include <string.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define M_TEXT(___v, ___t) \
    ((void *) ((char *) (___v) + (___t)))

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

#if __DELAY_MERGE__
int
_libx1f4l2_trap_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned index,
		       void *dhmiss)
#else
int
_libx1f4l2_trap_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned index)
#endif				/* __DELAY_MERGE__ */
{
    int status = 0;
    struct fpnode_type *fpnode_last, *fpnode_post;
    unsigned call, fine, last, miss, post;

    miss = qsrate(qsrate)->link_a.fplist.line >> 1;

    fine = 1 << qsrate(qsrate)->link_a.fplist.lock;

    call = fpnode_data - fpnode_line;

    fpnode_last = fpnode_data;

    fpnode_post = fpnode_data;

    if (near == &qsrate(qsrate)->link_a.fplist.node) {
	last = call;
	while (last) {
	    last--;
	    fpnode_last--;
	    if (fpnode_last->node) {
		break;
	    }
	}

	post = fine - 1 - call;
	while (post) {
	    post--;
	    fpnode_post++;
	    if (fpnode_post->node) {
		break;
	    }
	}

	fpnode_data->node = 0;

	last = fpnode_last->node;

	post = fpnode_post->node;
    } else {
	if (call & 1) {
	    fpnode_last--;
	    last = fpnode_last->node;
	    if (miss < last) {
		if ((call + 1) ^ fine) {
		    fpnode_post++;
		    post = fpnode_post->node;
		    if (last < post) {
		    } else {
			post = 0;
		    }
		} else {
		    post = 0;
		}
	    } else {
		post = 0;
	    }
	} else {
	    if (call) {
		fpnode_post++;
		post = fpnode_post->node;
		if (miss < post) {
		    last = 0;
		} else {
		    fpnode_last--;
		    last = fpnode_last->node;

		    if (last) {
			if (post) {
			} else {
			    if ((call + 2) ^ fine) {
				fpnode_post++;
				post = fpnode_post->node;
				if (last < post) {
				} else {
				    post = 0;
				}
			    }
			}
		    } else {
			fpnode_last--;
			last = fpnode_last->node;

			if (post) {
			    if (post < last) {
			    } else {
				last = 0;
			    }
			} else {
			    if ((call + 2) ^ fine) {
				fpnode_post++;
				post = fpnode_post->node;
			    }
			}
		    }
		}
	    } else {
		last = 0;

		fpnode_post++;
		post = fpnode_post->node;
		if (post) {
		} else {
		    fpnode_post++;
		    post = fpnode_post->node;
		}
	    }
	}
    }

    if (post < last) {
	if (miss < last) {
	    unsigned mall, seek;
	    void *fpnode, *fqnode;

	    seek = last - miss;

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    fpnode = fpnode_data->star;
	    fqnode = fpnode_last->star;

	    if (2 < seek) {
		seek++;
		seek >>= 1;
		memmove(M_TEXT(fpnode, (seek + index) * mall),
			M_TEXT(fpnode, (index + 1) * mall),
			(miss - index - 1) * mall);
		memmove(M_TEXT(fpnode, seek * mall), fpnode, index * mall);
		last -= seek;
		memcpy(fpnode, M_TEXT(fqnode, last * mall), seek * mall);
		fpnode_data->node = miss + seek - 1;
	    } else {
		memmove(M_TEXT(fpnode, mall), fpnode, index * mall);
		last--;
		memcpy(fpnode, M_TEXT(fqnode, last * mall), mall);
		seek = 1;
		fpnode_data->node = miss;
	    }

	    fpnode_last->node = last;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		last = fpnode_last - fpnode_line;

		last++;
		do {
		    (fpnode_line + last)->call -= seek;
		    last += last & ~(last - 1);
		} while (last < fine);

		call++;
		while (call < fine) {
		    (fpnode_line + call)->call += seek;
		    call += call & ~(call - 1);
		}
	    } else {
		fpnode_data->call -= seek;

		if (call & 1) {
		} else {
		    unsigned slip;

		    last = fpnode_last - fpnode_line;

		    if (last & 1) {
		    } else {
			(fpnode_last + 1)->call -= seek;
		    }

		    slip = 1;
		    do {
			(fpnode_data + slip)->call += seek;
			slip <<= 1;
		    } while (slip & ~call);
		}
	    }
	} else {
	    unsigned mall, slip, text;
	    void *fpnode, *fqnode;

#if __DELAY_MERGE__
	    if (((struct dhmiss_type *) dhmiss)->hook) {
# if __STAMP_MERGE__
# else
		unsigned mind = 0;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
# else
		if (index == fpnode_data->node - 1) {
		    mind = 1;
		}
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
		status = _libx1f4l2_type_qsrate
		    (qsrate, dhmiss, &near, &fpnode_line, &fpnode_data);
# else
		status = _libx1f4l2_type_qsrate
		    (qsrate, dhmiss, mind, &near, &fpnode_line, &fpnode_data);
# endif				/* __STAMP_MERGE__ */

		call = fpnode_data - fpnode_line;

		fpnode_last = fpnode_data - 1;
		if (fpnode_last->node) {
		} else {
		    fpnode_last--;
		}
	    }
#endif				/* __DELAY_MERGE__ */

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    fpnode = fpnode_data->star;
	    fqnode = fpnode_last->star;

	    if (0) {
	    } else {
		memcpy(M_TEXT(fqnode, mall * miss), fpnode, index * mall);
		memcpy(M_TEXT(fqnode, mall * (miss + index)),
		       M_TEXT(fpnode, (index + 1) * mall),
		       (miss - index - 1) * mall);
	    }

	    last <<= 1;
	    last--;

	    fpnode_data->node = 0;
	    fpnode_last->node = last;

	    last = fpnode_last - fpnode_line;

	    text = miss - 1;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
#if __DELAY_MERGE__
		int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

		excess = _libx1f4l2_bill_qsrate
		    (qsrate, near, fpnode_line, fpnode_last, last, fpnode_data,
		     call);
#if __DELAY_MERGE__
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
#endif				/* __DELAY_MERGE__ */
	    } else {
		if (call & 1) {
#if __DELAY_MERGE__
		    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

		    fpnode_data->call += text;

		    excess = _libx1f4l2_beta_qsrate
			(qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		} else {
		    if (last & 1) {
#if __DELAY_MERGE__
			int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
			void *star;

			star = fpnode_data->star;

			fpnode_data->node = fpnode_last->node;
			fpnode_data->star = fpnode_last->star;

			fpnode_last->node = 0;

			fpnode_last->star = star;

			text++;

			fpnode_data->call -= text;

			call++;

			slip = 1;
			do {
			    (fpnode_data + slip)->call += text;
			    slip <<= 1;
			} while (slip & ~call);

			call--;

			excess = _libx1f4l2_beta_qsrate
			    (qsrate, near, fpnode_line, last);
#if __DELAY_MERGE__
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		    } else {
#if __DELAY_MERGE__
			int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

			slip = (fpnode_data + 1)->call;

			(fpnode_data + 1)->call = 0;

			fpnode_data->call += slip;

			(fpnode_data - 1)->call += slip;

			excess = _libx1f4l2_beta_qsrate
			    (qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		    }
		}
	    }
	}
    } else {
	if (miss < post) {
	    unsigned mall, rail, seek;
	    void *fpnode, *fqnode;

	    seek = post - miss;

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    fpnode = fpnode_data->star;
	    fqnode = fpnode_post->star;

	    fpnode = M_TEXT(fpnode, index * mall);
	    rail = (miss - index - 1) * mall;
	    memmove(fpnode, M_TEXT(fpnode, mall), rail);
	    fpnode = M_TEXT(fpnode, rail);
	    if (2 < seek) {
		seek++;
		seek >>= 1;
		memcpy(fpnode, fqnode, seek * mall);
		post -= seek;
		memmove(fqnode, M_TEXT(fqnode, seek * mall), post * mall);
		rail = miss + seek - 1;
		fpnode_data->node = rail;
	    } else {
		memcpy(fpnode, fqnode, mall);
		post--;
		memmove(fqnode, M_TEXT(fqnode, mall), post * mall);
		fpnode_data->node = miss;
		seek = 1;
	    }

	    fpnode_post->node = post;

	    post = fpnode_post - fpnode_line;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		post++;
		while (post < fine) {
		    (fpnode_line + post)->call -= seek;
		    post += post & ~(post - 1);
		}

		call++;
		do {
		    (fpnode_line + call)->call += seek;
		    call += call & ~(call - 1);
		} while (call < fine);
	    } else {
		fpnode_post->call += seek;

		if (post & 1) {
		} else {
		    unsigned slip;

		    if (call & 1) {
		    } else {
			(fpnode_post - 1)->call += seek;
		    }

		    slip = 1;
		    do {
			(fpnode_post + slip)->call -= seek;
			slip <<= 1;
		    } while (slip & ~post);
		}
	    }
	} else {
	    unsigned mall, slip;
	    void *fpnode, *fqnode;

#if __DELAY_MERGE__
	    if (((struct dhmiss_type *) dhmiss)->hook) {
# if __STAMP_MERGE__
# else
		unsigned mind = 0;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
# else
		if (index == fpnode_data->node - 1) {
		    mind = 1;
		}
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
		status = _libx1f4l2_type_qsrate
		    (qsrate, dhmiss, &near, &fpnode_line, &fpnode_data);
# else
		status = _libx1f4l2_type_qsrate
		    (qsrate, dhmiss, mind, &near, &fpnode_line, &fpnode_data);
# endif				/* __STAMP_MERGE__ */

		call = fpnode_data - fpnode_line;

		fpnode_post = fpnode_data + 1;
		if (fpnode_post->node) {
		} else {
		    fpnode_post++;
		}
	    }
#endif				/* __DELAY_MERGE__ */

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    fpnode = fpnode_data->star;
	    fqnode = fpnode_post->star;

	    if (0) {
	    } else {
		memmove(M_TEXT(fpnode, index * mall),
			M_TEXT(fpnode, (index + 1) * mall),
			(miss - 1 - index) * mall);
		memcpy(M_TEXT(fpnode, (miss - 1) * mall), fqnode, miss * mall);
	    }

	    post <<= 1;
	    post--;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
#if __DELAY_MERGE__
		int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

		fpnode_data->node = post;
		fpnode_post->node = 0;

		excess = _libx1f4l2_mail_qsrate
		    (qsrate, near, fpnode_line, fpnode_data, call,
		     fpnode_post);
#if __DELAY_MERGE__
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
#endif				/* __DELAY_MERGE__ */
	    } else {
		fpnode_data->star = fqnode;
		fpnode_post->star = fpnode;

		fpnode_data->node = 0;
		fpnode_post->node = post;

		if (call & 1) {
#if __DELAY_MERGE__
		    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

		    miss--;

		    fpnode_post->call -= miss;

		    call++;

		    slip = 1;
		    do {
			(fpnode_post + slip)->call += miss;
			slip <<= 1;
		    } while (slip & ~call);

		    call--;

		    excess = _libx1f4l2_beta_qsrate
			(qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		} else {
		    post = fpnode_post - fpnode_line;
		    if (post & 1) {
#if __DELAY_MERGE__
			int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
			void *star;

			star = fpnode_data->star;

			fpnode_data->node = fpnode_post->node;
			fpnode_data->star = fpnode_post->star;

			fpnode_post->star = star;

			fpnode_post->call = (miss << 1) - 1;

			excess = _libx1f4l2_beta_qsrate
			    (qsrate, near, fpnode_line, post);
#if __DELAY_MERGE__
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		    } else {
#if __DELAY_MERGE__
			int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */

			(fpnode_post - 1)->call = 0;

			miss--;

			fpnode_post->call -= miss;

			call += 2;

			slip = 1;
			do {
			    (fpnode_post + slip)->call += miss;
			    slip <<= 1;
			} while (slip & ~call);

			call -= 2;

			excess = _libx1f4l2_beta_qsrate
			    (qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		    }
		}
	    }
	}
    }

    return status;
}
