/*
 * qscc.k.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static void rate_node(struct fpnode_type *, unsigned, unsigned);

static void
rate_node(struct fpnode_type *fpnode_data, unsigned line, unsigned mail)
{
    unsigned i;

    fpnode_data += line << 1;

    if (0) {
    } else {
	unsigned call, j, news, s = 1;

	call = mail;
	news = call;
	j = ~line;
	while (j & 1) {
	    s <<= 1;
	    news -= (fpnode_data - s)->call;
	    j >>= 1;
	}

	fpnode_data--;

	fpnode_data->call = news;
	fpnode_data->node = 0;
    }
    for (i = line - 1; i; i--) {
	unsigned call, j, news, s = 1;

	fpnode_data--;

	call = fpnode_data->call;
	news = call;
	j = ~i;
	while (j & 1) {
	    s <<= 1;
	    news -= (fpnode_data - s)->call;
	    j >>= 1;
	}

	fpnode_data--;

	fpnode_data->call = news;
	fpnode_data->node = 0;
    }
}


int
_libx1f4l2_gray_qsrate(void *qsrate)
{
    int status;
    unsigned lock;
    void *side;

    lock = qsrate(qsrate)->link_a.fplist.lock;

    status = qsrate(qsrate)->link_m.link
	(qsrate(qsrate)->link_m.data, &side,
	 sizeof(struct fpnode_type) << lock);
    if (status) {
	status = _libx1f4l2_rack_qsrate(qsrate, 1, &side);
    }

    if (0) {
    } else {
	struct fpnode_type *fpnode_data, *fpnode_link, *fpnode_text;
	unsigned half, i, miss, slip, tile;
	void *sale;

	fpnode_data = qsrate(qsrate)->link_a.fplist.fpnode;

	sale = fpnode_data->star;

	fpnode_link = side;

	fpnode_text = sale;

	half = 1 << lock >> 1;

	fpnode_text += half;

	miss = fpnode_text->call;

	slip = half;

	fpnode_data += slip;

	while (slip) {
	    fpnode_data->call = miss;
	    slip >>= 1;
	    fpnode_data -= slip;
	}

	fpnode_data--;

	fpnode_data->node = half;

	i = half;
	for (; i; i--) {
	    *fpnode_link = *fpnode_text++;
	    fpnode_link += 2;
	}

	tile = qsrate(qsrate)->link_a.fplist.size - miss;

	rate_node(side, half, tile);

	fpnode_link = sale;

	fpnode_link += half;

	i = half;
	for (; i; i--) {
	    fpnode_text -= 2;
	    *fpnode_text = *--fpnode_link;
	}

	rate_node(sale, half, miss);

	slip = half;

	fpnode_data += slip;

	slip >>= 1;

	fpnode_data += slip;

	while (slip) {
	    fpnode_data->call = tile;
	    slip >>= 1;
	    fpnode_data -= slip;
	}

	fpnode_data--;

	fpnode_data->node = half;
	fpnode_data->star = side;

	qsrate(qsrate)->link_a.fplist.node = 2;
    }

    return status;
}
