/*
 * qscc.j.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_blue_qsrate(void *qsrate)
{
    int status;
    unsigned flat, line, mall;
    void *side;

    flat = qsrate(qsrate)->link_a.fplist.line;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    line = flat * mall;

    status = qsrate(qsrate)->link_m.link
	(qsrate(qsrate)->link_m.data, &side, line);
    if (status) {
	status = _libx1f4l2_rack_qsrate(qsrate, 0, &side);
    }

    if (0) {
    } else {
	struct fpnode_type *fpnode_data;
	unsigned lock, half, slip;
	void *sale;

	flat *= 3;
	flat >>= 2;

	lock = qsrate(qsrate)->link_a.fplist.lock;

	fpnode_data = qsrate(qsrate)->link_a.fplist.fpnode;

	slip = 1 << lock >> 1;

	fpnode_data += slip;

	while (slip) {
	    fpnode_data->call = flat;
	    slip >>= 1;
	    fpnode_data -= slip;
	}

	fpnode_data--;

	sale = fpnode_data->star;

	fpnode_data->node = flat;

	half = flat * mall;

	memcpy(side, (char *) sale + half, half);
	if (qsrate(qsrate)->link_m.mode
	    (qsrate(qsrate)->link_m.data, &sale, line)) {
	} else {
	    fpnode_data->star = sale;
	}

	slip = 1 << lock >> 1;

	fpnode_data += slip;

	slip >>= 1;

	fpnode_data += slip;

	while (slip) {
	    fpnode_data->call = flat;
	    slip >>= 1;
	    fpnode_data -= slip;
	}

	fpnode_data--;

	fpnode_data->node = flat;
	fpnode_data->star = side;

	qsrate(qsrate)->link_a.fplist.node = 2;
    }

    return status;
}
