/*
 * qscc.h.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_fall_qsrate(void *qsrate)
{
    int (*link) (void *, void **, unsigned), status;
    unsigned lock, rate, size;
    void *data, *fall;

    lock = qsrate(qsrate)->link_a.fplist.lock;

    data = qsrate(qsrate)->link_m.data;
    link = qsrate(qsrate)->link_m.link;

    rate = qsrate(qsrate)->link_a.fplist.rate;

    size = sizeof(struct fpnode_type) << lock;

    status = link(data, &fall, size);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *mall;

	if (rate) {
	} else {
	    size = qsrate(qsrate)->link_a.fplist.line * 3
		* qsrate(qsrate)->link_a.fplist.mall >> 1;
	}

	status = link(data, &mall, size);
	if (status) {
	    status = LINK_ERROR;

	    qsrate(qsrate)->link_m.free(data, fall);
	} else {
	    struct fpnode_type *fpnode_data;

	    {
		unsigned i;

		fpnode_data = fall;

		i = 1 << lock;
		for (; i; i--) {
		    fpnode_data->call = 0;
		    fpnode_data->node = 0;
		    fpnode_data++;
		}

		fpnode_data = fall;

		fpnode_data->star = qsrate(qsrate)->link_a.fplist.fpnode;

		qsrate(qsrate)->link_a.fplist.fpnode = fall;
		qsrate(qsrate)->link_a.fplist.node = 1;
	    }

	    if (rate) {
		struct fplink_type *fplink_data;

		fplink_data = mall;
		fplink_data->fplink_data =
		    qsrate(qsrate)->link_e.fplink_data;
		qsrate(qsrate)->link_e.fplink_data = mall;

		qsrate(qsrate)->link_a.fplist.rate = rate + 1;

		status = _libx1f4l2_gray_qsrate(qsrate);
	    } else {
		qsrate(qsrate)->link_e.fplink_text = mall;

		qsrate(qsrate)->link_a.fplist.rate = 1;

		status = _libx1f4l2_blue_qsrate(qsrate);
	    }
	}
    }

    return status;
}
