/*
 * qcee.e.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int fini_list(struct qsrate_type *);

static int
fini_list(struct qsrate_type *qsrate_data)
{
    int status;

    status = qsrate_data->link_m.free
	(qsrate_data->link_m.data, qsrate_data->link_a.fplist.fpnode);
    if (status) {
	status = FREE_ERROR;
    }

    return status;
}


int
x1f4_flat_qsrate(void *qsrate)
{
    int excess, status;

    status = _libx1f4l2_ceil_qsrate(qsrate);
    excess = fini_list(qsrate);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
