/*
 * qscc.b.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>
#include <trans.h>

static int fini_list(void **);
static int init_list(void **, struct qsrate_type *);
static int text_list(struct qsrate_type *, struct qsrate_type *,
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);

static int
fini_list(void **text)
{
    return _libx1f4l2_fini_qsrate(text);
}


static int
init_list(void **text, struct qsrate_type *qsrate_data)
{
    int status;
    struct screen_type screen;
    struct trans_type trans;

    screen.half = qsrate_data->link_a.fplist.line >> 2;
    screen.rate = qsrate_data->link_a.fplist.lock;
    screen.size = qsrate_data->link_a.fplist.mall;

    screen.trans_data = &trans;

    trans.data = qsrate_data->link_m.data;
    trans.free = qsrate_data->link_m.free;
    trans.link = qsrate_data->link_m.link;
    trans.mode = qsrate_data->link_m.mode;

    status = _libx1f4l2_init_qsrate
	(text, HALF_FRAME | RATE_FRAME | TRANS_MASK, &screen);

    return status;
}


static int
text_list(struct qsrate_type *qsrate_data, struct qsrate_type *qsrate_text,
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    int status;

    if (qsrate_text->link_a.fplist.size) {
	status = _libx1f4l2_here_qsrate
	    (qsrate_data, qsrate_text, copy, free, context);
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_text_qsrate(void **qsrate, void *qstext,
		 int (*copy) (void *, void *, const void *),
		 int (*free) (void *, void *), void *context)
{
    int status;
    void *text;

    status = init_list(&text, qstext);
    if (status) {
    } else {
	status = text_list(text, qstext, copy, free, context);
	if (status) {
	    fini_list(&text);
	} else {
	    *qsrate = text;
	}
    }

    return status;
}
