/*
 * qscc.a.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
x1f4_line_qsrate(void *qsdata, void *qstext,
		 int (*copy) (void *, void *, const void *),
		 int (*free) (void *, void *), void *context)
{
    int status;

    if (qsrate(qsdata)->link_a.fplist.size) {
	status = SIZE_ERROR;
    } else {
	if (qsrate(qstext)->link_a.fplist.size) {
	    if ((qsrate(qstext)->link_a.fplist.line
		 ^ qsrate(qsdata)->link_a.fplist.line)
		| (qsrate(qstext)->link_a.fplist.lock
		   ^ qsrate(qsdata)->link_a.fplist.lock)
		| (qsrate(qstext)->link_a.fplist.mall
		   ^ qsrate(qsdata)->link_a.fplist.mall)) {
		status = TEXT_ERROR;
	    } else {
		status = _libx1f4l2_here_qsrate
		    (qsdata, qstext, copy, free, context);
	    }
	} else {
	    status = 0;
	}
    }

    return status;
}
