/*
 * qscc.7.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int back_node
    (void *, unsigned, unsigned, void *, int (*) (void *, void *));
static int fast_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
     int (*) (void *, void *));
static int jack_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
     int (*) (void *, void *));

static int
back_node(void *node, unsigned pick, unsigned mall, void *back,
	  int (*call) (void *, void *))
{
    int delete;

    do {
	delete = call(back, node);
	if (delete) {
	    break;
	}

	pick--;

	node = (char *) node + mall;
    } while (pick);

    return delete;
}


static int
fast_node(struct fpnode_type *fpnode_data, unsigned line, unsigned zero,
	  unsigned mall, void *back, int (*call) (void *, void *))
{
    int delete = 0;

    for (; line; line--) {
	unsigned node;

	node = fpnode_data->node;
	if (node) {
	    delete = back_node(fpnode_data->star, node, mall, back, call);
	    if (delete) {
		break;
	    }
	}

	fpnode_data++;
    }

    return delete;
}


static int
jack_node(struct fpnode_type *fpnode_data, unsigned line, unsigned rate,
	  unsigned mall, void *back, int (*call) (void *, void *))
{
    int delete = 0,
	(*pick) (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
		 int (*) (void *, void *));
    unsigned i;

    rate--;

    if (rate) {
	pick = jack_node;
    } else {
	pick = fast_node;
    }

    i = line;
    for (; i; i--) {
	if (fpnode_data->node) {
	    delete = pick
		(fpnode_data->star, line, rate, mall, back, call);
	    if (delete) {
		break;
	    }
	}

	fpnode_data++;
    }

    return delete;
}


int
x1f4_lime_qsrate(void *qsrate, void *back, int (*call) (void *, void *))
{
    int delete;
    unsigned mall, rate;
    void *node;

    node = qsrate(qsrate)->link_a.fplist.fpnode;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    rate = qsrate(qsrate)->link_a.fplist.rate;

    if (rate) {
	unsigned line;

	line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	rate--;
	if (rate) {
	    delete = jack_node(node, line, rate, mall, back, call);
	} else {
	    delete = fast_node(node, line, rate, mall, back, call);
	}
    } else {
	unsigned size;

	size = qsrate(qsrate)->link_a.fplist.size;
	if (size) {
	    delete = back_node(node, size, mall, back, call);
	} else {
	    delete = 0;
	}
    }

    return delete;
}
