/*
 * qscc.4.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define M_TEXT(___v, ___t) \
    ((void *) ((char *) (___v) + (___t)))

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
x1f4_peek_qsrate(void *qsrate, unsigned index, void **peek)
{
    int status;
    unsigned count;

    count = qsrate(qsrate)->link_a.fplist.size;

    if (!(index < count)) {
	status = DECK_ERROR;
    } else {
	unsigned rate;
	void *node;

	node = qsrate(qsrate)->link_a.fplist.fpnode;

	status = 0;

	rate = qsrate(qsrate)->link_a.fplist.rate;

	if (rate) {
	    struct fpnode_type *fpnode_data;
	    unsigned *cell, lock;

	    fpnode_data = node;

	    lock = qsrate(qsrate)->link_a.fplist.lock;

	    do {
		unsigned half;

		half = lock;

		cell = &fpnode_data->call;

		while (3 < half) {
		    unsigned *call, news, sail;

		    sail = sizeof(struct fpnode_type) << half;

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    news = *call;
		    if (index < news) {
		    } else {
			index -= news;
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    news = *call;
		    if (index < news) {
		    } else {
			index -= news;
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    news = *call;
		    if (index < news) {
		    } else {
			index -= news;
			cell = call;
		    }

		    sail >>= 1;
		    call = (void *) ((char *) cell + sail);

		    news = *call;
		    if (index < news) {
		    } else {
			index -= news;
			cell = call;
		    }

		    half -= 4;
		}
		while (half) {
		    unsigned *call, news;

		    half--;

		    call = (void *)
			((char *) cell + (sizeof(struct fpnode_type) << half));

		    news = *call;
		    if (index < news) {
		    } else {
			index -= news;
			cell = call;
		    }
		}

		fpnode_data = (void *)
		    ((char *) cell - offsetof(struct fpnode_type, call));

		fpnode_data = fpnode_data->star;

		rate--;
	    } while (rate);

	    node = fpnode_data;
	}

	*peek = M_TEXT(node, index * qsrate(qsrate)->link_a.fplist.mall);
    }

    return status;
}
