/*
 * qscc.2.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>
#include <string.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

#if __DELAY_SPLIT__
static int part_late(struct qsrate_type *, unsigned, void *, void *, unsigned,
		     struct fpnode_type **, struct fpnode_type **);
#endif				/* __DELAY_SPLIT__ */

#if __DELAY_SPLIT__
static int
part_late(struct qsrate_type *qsrate_data, unsigned rate, void *miss,
	  void *node, unsigned index, struct fpnode_type **link,
	  struct fpnode_type **push)
{
    int status = 0;
    struct fpnode_type *fpnode_call, *fpnode_data;
    unsigned collect, lock;

    lock = qsrate_data->link_a.fplist.lock;

    fpnode_call = *link;
    fpnode_data = *push;

    fpnode_data->node = QSBITS + 1;

    collect = fpnode_data - (struct fpnode_type *) fpnode_call->star;

    fpnode_call = miss;
    fpnode_data = node;

    rate--;
    while (rate) {
	int excess;
	unsigned text;

	text = ((struct fpnode_type *) fpnode_data->star)->call;

	excess = _libx1f4l2_sand_qsrate
	    (qsrate_data, fpnode_call, &fpnode_data, &index, 1 + rate);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	fpnode_call = fpnode_data;

	fpnode_data = fpnode_data->star;

	rate--;

	index = text >> lock;
	fpnode_data += (text & ((1 << lock >> 1) - 1)) << 1;
    }
    {
	int excess;

	excess = _libx1f4l2_sand_qsrate
	    (qsrate_data, fpnode_call, &fpnode_data, &index, 1);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	fpnode_call = fpnode_data;

	fpnode_data = fpnode_data->star;
    }

    fpnode_data += (collect & ((1 << lock >> 1) - 1)) << 1;

    fpnode_data->node = QSBITS;

    *link = fpnode_call;
    *push = fpnode_data;

    return status;
}
#endif				/* __DELAY_SPLIT__ */


int
x1f4_push_qsrate(void *qsrate, unsigned index, void **push)
{
    int status;
    unsigned count;

    count = qsrate(qsrate)->link_a.fplist.size;

    if (count < index) {
	status = DECK_ERROR;
    } else {
	unsigned rate;

	status = 0;

	rate = qsrate(qsrate)->link_a.fplist.rate;

	do {
	    void *node;

	    if (rate) {
		struct fpnode_type *fpnode_data;
#if __DELAY_SPLIT__
		unsigned black = 0, late = 0;
#endif				/* __DELAY_SPLIT__ */
		unsigned lock;
#if __DELAY_SPLIT__
		void *hook = NULL, *sail = NULL;
#endif				/* __DELAY_SPLIT__ */

		lock = qsrate(qsrate)->link_a.fplist.lock;

		if (qsrate(qsrate)->link_a.fplist.node >> lock) {
		    status = _libx1f4l2_fall_qsrate(qsrate);
		    if (status) {
			break;
		    } else {
			rate++;
		    }
		}

		qsrate(qsrate)->link_a.fplist.size = count + 1;

		fpnode_data = qsrate(qsrate)->link_a.fplist.fpnode;

		if (1) {
		    struct fpnode_type *fpnode_call = NULL;

		    if (1) {
			unsigned half;

			half = 1 << lock >> 1;

			while (half) {
			    struct fpnode_type *fpnode_slip;
			    unsigned pick;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				if (pick) {
				    fpnode_slip->call = pick + 1;
				} else {
				    fpnode_data = fpnode_slip;
				}
			    }

			    half >>= 1;
			}

			rate--;
		    }

		    while (rate) {
			unsigned half;

			if (fpnode_data->node >> lock) {
#if __DELAY_SPLIT__
			    if (hook) {
				struct fpnode_type *fpnode_slip;

				fpnode_slip = fpnode_call->star;
				fpnode_slip->call = index << lock
				    | (fpnode_data - fpnode_slip);
			    } else {
				hook = fpnode_data;
				sail = fpnode_call;
				if (1) {
				    late = rate;
				    if (1) {
					black = index;
				    }
				}
			    }
#else
			    int excess;

			    excess = _libx1f4l2_sand_qsrate
				(qsrate, fpnode_call, &fpnode_data, &index,
				 rate);
			    if (excess) {
				if (status) {
				} else {
				    status = excess;
				}
			    }
#endif				/* __DELAY_SPLIT__ */
#if __DELAY_SPLIT__
			} else {
			    hook = NULL;
#endif				/* __DELAY_SPLIT__ */
			}

			fpnode_call = fpnode_data;

			fpnode_data = fpnode_data->star;

			half = 1 << lock >> 1;

			while (4 < half) {
			    struct fpnode_type *fpnode_slip;
			    unsigned pick;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				fpnode_slip->call = pick + 1;
			    }

			    half >>= 1;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				fpnode_slip->call = pick + 1;
			    }

			    half >>= 1;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				fpnode_slip->call = pick + 1;
			    }

			    half >>= 1;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				fpnode_slip->call = pick + 1;
			    }

			    half >>= 1;
			}
			while (half) {
			    struct fpnode_type *fpnode_slip;
			    unsigned pick;

			    fpnode_slip = fpnode_data + half;
			    pick = fpnode_slip->call;
			    if (pick < index) {
				index -= pick;
				fpnode_data = fpnode_slip;
			    } else {
				fpnode_slip->call = pick + 1;
			    }

			    half >>= 1;
			}

			rate--;
		    }

		    if (fpnode_data->node
			== qsrate(qsrate)->link_a.fplist.line) {
			int excess;

#if __DELAY_SPLIT__
			if (hook) {
			    excess = part_late
				(qsrate, late, sail, hook, black, &fpnode_call,
				 &fpnode_data);
			    if (excess) {
				if (status) {
				} else {
				    status = excess;
				}
			    }
			}
#endif				/* __DELAY_SPLIT__ */

			excess = _libx1f4l2_mold_qsrate
			    (qsrate, fpnode_call, &fpnode_data, &index);
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
		    }

		    count = fpnode_data->node;

		    fpnode_data->node = count + 1;
		}

		node = fpnode_data->star;
	    } else {
		unsigned trail;

		trail = 3 * qsrate(qsrate)->link_a.fplist.line >> 1;
		if (count ^ trail) {
#if __MICRO_RATES__
		    while (count < trail && ~trail & 1) {
			trail >>= 1;
		    }

		    if (count ^ trail) {
		    } else {
			status = _libx1f4l2_even_qsrate(qsrate, index, push);
			if (1) {
			    break;
			}
		    }
#endif				/* __MICRO_RATES__ */

		    qsrate(qsrate)->link_a.fplist.size = count + 1;

		    node = qsrate(qsrate)->link_a.fplist.fpnode;
		} else {
		    status = _libx1f4l2_rail_qsrate
			(qsrate, &index, &node, &count);
		    if (status) {
			break;
		    }
		}
	    }

	    {
		unsigned mall;

		mall = qsrate(qsrate)->link_a.fplist.mall;

		node = (char *) node + index * mall;

		count -= index;
		if (count) {
		    memmove((char *) node + mall, node, count * mall);
		} else {
		}

		*push = node;
	    }
	} while (0);
    }

    return status;
}
