/*
 * qscc-inter.h
 * Copyright (C) 2008-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#ifndef __LIBx1f4_qscc_inter_H__
#define __LIBx1f4_qscc_inter_H__

#include <qscc-config.h>

#include <qscc-names.h>
#include <qscc-types.h>

#if !defined _libx1f4l2_fast_qsrate
# define _libx1f4l2_fast_qsrate		x1f4_fast_qsrate
#endif				/* !_libx1f4l2_fast_qsrate */
#if !defined _libx1f4l2_fini_qsrate
# define _libx1f4l2_fini_qsrate		x1f4_fini_qsrate
#endif				/* !_libx1f4l2_fini_qsrate */
#if !defined _libx1f4l2_flat_qsrate
# define _libx1f4l2_flat_qsrate		x1f4_flat_qsrate
#endif				/* !_libx1f4l2_flat_qsrate */
#if !defined _libx1f4l2_init_qsrate
# define _libx1f4l2_init_qsrate		x1f4_init_qsrate
#endif				/* !_libx1f4l2_init_qsrate */
#if !defined _libx1f4l2_peek_qsrate
# define _libx1f4l2_peek_qsrate		x1f4_peek_qsrate
#endif				/* !_libx1f4l2_peek_qsrate */

extern int _libx1f4l2_away_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *,
     unsigned *, unsigned **, void **);
extern int _libx1f4l2_beta_qsrate
    (void *, unsigned *, struct fpnode_type *, unsigned);
extern int _libx1f4l2_bill_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     struct fpnode_type *, unsigned);
extern int _libx1f4l2_blue_qsrate(void *);
extern int _libx1f4l2_ceil_qsrate(void *);
extern int _libx1f4l2_else_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     struct fpnode_type *, unsigned, unsigned, unsigned *, unsigned **,
     void **);
#if __MICRO_RATES__
extern int _libx1f4l2_even_qsrate(void *, unsigned, void **);
#endif				/* __MICRO_RATES__ */
extern int _libx1f4l2_fair_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     struct fpnode_type *, unsigned, unsigned, unsigned **, void **);
extern int _libx1f4l2_fall_qsrate(void *);
extern int _libx1f4l2_fast_qsrate(void *, unsigned, struct screen_type *);
extern int _libx1f4l2_fini_qsrate(void **);
extern int _libx1f4l2_flat_qsrate(void *);
extern int _libx1f4l2_gray_qsrate(void *);
extern int _libx1f4l2_here_qsrate
    (void *, void *, int (*) (void *, void *, const void *),
     int (*) (void *, void *), void *);
extern int _libx1f4l2_init_qsrate(void **, unsigned, struct screen_type *);
#if __DELAY_MERGE__
extern int _libx1f4l2_long_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     void *);
#else
extern int _libx1f4l2_long_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned);
#endif				/* __DELAY_MERGE__ */
extern int _libx1f4l2_mail_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     struct fpnode_type *);
extern int _libx1f4l2_mold_qsrate
    (void *, struct fpnode_type *, struct fpnode_type **, unsigned *);
extern int _libx1f4l2_moon_qsrate
    (void *, unsigned *, struct fpnode_type *, unsigned);
extern int _libx1f4l2_park_qsrate
    (void *, struct fpnode_type *, unsigned, unsigned);
extern int _libx1f4l2_peek_qsrate(void *, unsigned, void **);
extern int _libx1f4l2_rack_qsrate(void *, unsigned, void **);
extern int _libx1f4l2_rail_qsrate(void *, unsigned *, void **, unsigned *);
extern int _libx1f4l2_sail_qsrate
    (void *, struct fpnode_type **, unsigned, void *, unsigned *,
     struct fpnode_type **);
extern int _libx1f4l2_sand_qsrate
    (void *, struct fpnode_type *, struct fpnode_type **, unsigned *,
     unsigned);
#if __DELAY_MERGE__
extern int _libx1f4l2_trap_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned,
     void *);
#else
extern int _libx1f4l2_trap_qsrate
    (void *, unsigned *, struct fpnode_type *, struct fpnode_type *, unsigned);
#endif				/* __DELAY_MERGE__ */
extern int _libx1f4l2_true_qsrate
    (void *, struct fpnode_type *, void *, struct fpnode_type **, unsigned *);
#if __DELAY_MERGE__ && __STAMP_MERGE__
extern int _libx1f4l2_type_qsrate
    (void *, void *, unsigned **, struct fpnode_type **,
     struct fpnode_type **);
#elif __DELAY_MERGE__
extern int _libx1f4l2_type_qsrate
    (void *, void *, unsigned, unsigned **, struct fpnode_type **,
     struct fpnode_type **);
#endif				/* __DELAY_MERGE__ && __STAMP_MERGE__ */

#endif				/* __LIBx1f4_qscc_inter_H__ */
