/*
 * qscb.y.c
 * Copyright (C) 2010-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>

#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_sail_qsrate(void *qsrate, struct fpnode_type **fqnode,
		       unsigned cell, void *side, unsigned *index,
		       struct fpnode_type **fpnode)
{
    int delete;
    struct fpnode_type *fpnode_data, *fpnode_line, *fpnode_slip = NULL,
	*fpnode_text = NULL;
    unsigned line, slip, text;

    fpnode_line = *fqnode;

    fpnode_data = fpnode_line + cell;

    slip = (fpnode_data + 1)->call;

    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

    text = 2;
    while (text & ~cell) {
	if (cell + text < line) {
	} else {
	    break;
	}

	/*
	 * may go top down instead
	 */
	if (fpnode_data[text].call == slip) {
	    fpnode_text = fpnode_slip;
	    fpnode_slip = fpnode_data + text;
	} else {
	    break;
	}

	text <<= 1;
    }
    if (fpnode_slip) {
	if (cell) {
	    struct fpnode_type *fpnode_rail;
	    unsigned size, slip, tile;

	    fpnode_rail = fpnode_data + text;
	    slip = cell + text;
	    if (slip == line) {
		size = qsrate(qsrate)->link_a.fplist.size;
	    } else {
		size = fpnode_rail->call;
	    }
	    slip = (slip & (slip - 1)) ^ slip;
	    tile = text >> 1;
	    slip >>= 1;
	    while (slip ^ tile) {
		size -= (fpnode_rail - slip)->call;
		slip >>= 1;
	    }
	    if (size == fpnode_slip->call) {
		fpnode_text = fpnode_slip;
	    }
	}
    }
    if (fpnode_text) {
	unsigned mind, miss, trans;

	delete = 1;

	line >>= 1;

	fpnode_data->node = line;

	fpnode_text->node = line;

	fpnode_text->star = side;

	if (0) {
	} else {
	    *fqnode = fpnode_text;
	}

	mind = ((struct fpnode_type *) fpnode_data->star + line)->call;

	trans = *index;
	if (trans < mind) {
#if __DELAY_SPLIT__
#else
	    mind++;
#endif				/* __DELAY_SPLIT__ */
	} else {
	    *index = trans - mind;
	    *fpnode = fpnode_text;
	}

	slip -= mind;

	fpnode_text->call = mind;

	text = fpnode_text - fpnode_line;

	miss = (text - cell) >> 1;
	while (miss) {
	    fpnode_text[miss].call = slip;
	    fpnode_data[miss].call = mind;
	    miss >>= 1;
	}
    } else {
	delete = 0;
    }

    return delete;
}
