/*
 * qscb.l.c
 * Copyright (C) 2011-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_even_qsrate(void *qsrate, unsigned index, void **push)
{
    int status;
    void *node;
    unsigned count, mall;

    node = qsrate(qsrate)->link_a.fplist.fpnode;

    count = qsrate(qsrate)->link_a.fplist.size;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    status = qsrate(qsrate)->link_m.mode
	(qsrate(qsrate)->link_m.data, &node, mall * count << 1);
    if (status) {
	status = MODE_ERROR;
    } else {
	qsrate(qsrate)->link_a.fplist.size = count + 1;

	qsrate(qsrate)->link_a.fplist.fpnode = node;

	node = (char *) node + index * mall;

	count -= index;
	if (count) {
	    memmove((char *) node + mall, node, count * mall);
	} else {
	}

	*push = node;
    }

    return status;
}
