/*
 * qscb.j.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_park_qsrate(void *qsrate, struct fpnode_type *fpnode_data,
		       unsigned rate, unsigned line)
{
    int status = 0;

    if (rate) {
	unsigned i;

	rate--;

	i = line;
	for (; i; i--) {
	    if (fpnode_data->node) {
		status = _libx1f4l2_park_qsrate
		    (qsrate, fpnode_data->star, rate, line);
		if (status) {
		    status = FREE_ERROR;
		    if (1) {
			break;
		    }
		} else {
		    fpnode_data->node = 0;
		}
	    }

	    fpnode_data++;
	}
    } else {
	line = 0;
    }

    if (status) {
    } else {
	status = qsrate(qsrate)->link_m.free
	    (qsrate(qsrate)->link_m.data, fpnode_data - line);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}
