/*
 * qscb.g.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_true_qsrate(void *qsrate, struct fpnode_type *fpnode_line,
		       void *side, struct fpnode_type **fpnode,
		       unsigned *index)
{
    int delete;
    struct fpnode_type *fpnode_data, *fpnode_slip = NULL, *fpnode_text = NULL;
    unsigned cell, flat, line, mall, text;

    flat = qsrate(qsrate)->link_a.fplist.line;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    fpnode_data = *fpnode;

    cell = fpnode_data - fpnode_line;

    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

    text = 2;
    while (text & ~cell) {
	if (cell + text < line) {
	} else {
	    break;
	}

	/*
	 * may go top down instead
	 */
	if (fpnode_data[text].call == flat + 1) {
	    fpnode_text = fpnode_slip;
	    fpnode_slip = fpnode_data + text;
	} else {
	    break;
	}

	text <<= 1;
    }
    if (fpnode_slip) {
	if (cell) {
	    struct fpnode_type *fpnode_rail;
	    unsigned size, slip, tile;

	    fpnode_rail = fpnode_data + text;
	    slip = cell + text;
	    if (slip == line) {
		size = qsrate(qsrate)->link_a.fplist.size;
	    } else {
		size = fpnode_rail->call;
	    }
	    slip = (slip & (slip - 1)) ^ slip;
	    tile = text >> 1;
	    slip >>= 1;
	    while (slip ^ tile) {
		size -= (fpnode_rail - slip)->call;
		slip >>= 1;
	    }
	    if (size == fpnode_slip->call) {
		fpnode_text = fpnode_slip;
	    }
	}
    }
    if (fpnode_text) {
	unsigned half, miss, trans;

	delete = 1;

	flat >>= 1;

	fpnode_data->node = flat;

	fpnode_text->node = flat;

	fpnode_text->star = side;

	half = flat * mall;

	trans = *index;
	if (trans < flat + 1) {
	    memcpy(side, (char *) fpnode_data->star + half, half);
	} else {
	    memcpy(side, (char *) fpnode_data->star + half + mall,
		   half - mall);
	    *index = trans - (flat + 1);
	    *fpnode = fpnode_text;
	    fpnode_text->node--;
	    fpnode_data->node++;
	}

	fpnode_text->call = flat + 1;

	text = fpnode_text - fpnode_line;

	miss = (text - cell) >> 1;
	while (miss) {
	    fpnode_text[miss].call = flat;
	    fpnode_data[miss].call = flat + 1;
	    miss >>= 1;
	}
    } else {
	delete = 0;
    }

    return delete;
}
