/*
 * nt.h
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_nt_H__
#define __LIBx1f4_nt_H__

#include <cl.h>
#include <nl.h>
#include <trans.h>

/*
 * common data type flag definitions
 */
#define X1f4_LX_LINK_ACCESS		(1L << 1)
#define X1f4_LX_PICK_ACCESS		(1L << 2)
#define X1f4_LX_POST_ACCESS		(1L << 3)
#define X1f4_LX_PULL_ACCESS		(1L << 4)

/*
 * common data type flag definitions (continued)
 */
#define X1f4_LX_FLAT_REFLEX		(1L << 0)

/*
 * common data type flag definitions (continued)
 */
#define X1f4_LX_TYPE_EXCEPT		(1L << 5)

/*
 * common data type flag definitions (continued)
 */
#define X1f4_LX_AUTO_RECORD		(1L << 7)

#if !defined __x1f4_nodetype_type_defined__
struct x1f4_caselink_type;
#endif				/* !__x1f4_nodetype_type_defined__ */

#if !defined __x1f4_nodetype_type_defined__
struct x1f4_nodelink_type;
#endif				/* !__x1f4_nodetype_type_defined__ */

#if !defined __x1f4_nodetype_type_defined__
typedef struct x1f4_nodetype_type {
    const char *name;
    int (*call) (struct x1f4_nodelink_type *), code,
	(*copy) (void *, void *, void **, const void *,
		 const struct x1f4_nodelink_type *),
	(*dump) (void *, struct x1f4_nodelink_type *),
	(*free) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*hash) (void *, struct x1f4_nodelink_type **,
		 struct x1f4_nodelink_type *),
	(*lead) (void *, void **),
	(*miss) (struct x1f4_nodelink_type **, struct x1f4_nodelink_type **,
		 struct x1f4_nodelink_type *),
	(*move) (void *, void *, const struct x1f4_nodelink_type *,
		 const struct x1f4_nodelink_type *),
	(*node) (void *, void **, void *, const struct x1f4_nodelink_type *),
	(*pick) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*post) (void *, void **, const struct x1f4_nodelink_type *),
	(*pull) (void *, void *, void *, const void *, struct trans_type *,
		 struct x1f4_caselink_type **),
	(*push) (void *, void **, void *, const struct x1f4_nodelink_type *),
	(*slip) (void *, void **);
    unsigned flags, size;
    void *context;
} x1f4_nodetype_type;
#endif				/* !__x1f4_nodetype_type_defined__ */

#if !defined __x1f4_nodetype_type_defined__
# define __x1f4_nodetype_type_defined__
#endif				/* !__x1f4_nodetype_type_defined__ */

#endif				/* __LIBx1f4_nt_H__ */
