/*
 * lxxsxx-2.p.c
 * Copyright (C) 2010, 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxfile.h>
#include <lxport-types.h>
#include <nl.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_PORT(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxport_p_2xshell(void *context, void *output, void **input)
{
    int status;
    struct lxport_type *lxport_data;
    struct x1f4_nodelink_type *nodelink_data;
    struct xsport_type *xsport_data;
    void *file, *node, *text;

    xsport_data = I_PORT(input[0]);

    file = I_FILE(input[1]);

    lxport_data = context;

    text = lxport_data->link_l.file;

    nodelink_data = lock_excase(xsport_data);

    status = x1f4_node_lxfile(text, &node, file, nodelink_data);
    if (status) {
    } else {
	void *note;

	note = xsport_data->note;
	if (note) {
	    status = x1f4_free_lxfile(text, note, NULL, nodelink_data);
	    if (status) {
		x1f4_free_lxfile(text, node, NULL, nodelink_data);
	    } else {
		xsport_data->note = node;
	    }
	} else {
	    xsport_data->note = node;
	}
    }

    return status;
}
