/*
 * lxxsxx-1.l.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#if defined HAVE_LIBx1f4l1
# include <libx1f4l1.h>
#endif				/* HAVE_LIBx1f4l1 */
#include <stddef.h>

#include <e4.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxdata.h>
#include <lxfile.h>
#include <lxlist.h>
#include <lxport-defs.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#if !defined HAVE_LIBx1f4l1
# include <xshell.h>
#endif				/* !HAVE_LIBx1f4l1 */

#define PORT_BITS \
    X1f4_XSHELL_ARGV_MASK | X1f4_XSHELL_C3RD_MASK | X1f4_XSHELL_HEAD_MASK     \
    | X1f4_XSHELL_LOOK_MASK | X1f4_XSHELL_PATH_MASK | X1f4_XSHELL_TAIL_MASK   \
    | X1f4_XSHELL_TYPE_MASK

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_PORT(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define xsport(port) \
    ((struct xsport_type *) (port))

#define byte(miss)			((unsigned char *) (miss))

typedef struct land_type {
    const char **argv;
    int data;
} land_type;

static int link_port(struct lxport_type *, struct xsport_type *,
		     const char **);
static int lock_port(struct lxport_type *, int);
static int slip_port(struct lxport_type *, struct xsport_type *);
static int type_list(void *, void *);

static int
link_port(struct lxport_type *lxport_data, struct xsport_type *xsport_data,
	  const char **argv)
{
    int status;
    void *xshell;

    status = x1f4_init_xshell(&xshell);
    if (status) {
	status = _libx1f4i0_lxport_stat_link(lxport_data);
    } else {
	int excess;
	struct x1f4_dxfile_type *dxfile_data;
	struct x1f4_xshell_type Xshell;
	unsigned bits = PORT_BITS;

	dxfile_data = xsport_data->note;
	if (dxfile_data) {
	    if (dxfile_data->file) {
		bits |= X1f4_XSHELL_LIFT_MASK;
		if (1) {
		    x1f4_bill_dxfile(dxfile_data, &Xshell.adapter.lift);
		}
	    }
	}

	dxfile_data = xsport_data->side;
	if (dxfile_data) {
	    if (dxfile_data->file) {
		bits |= X1f4_XSHELL_LEAD_MASK;
		if (1) {
		    x1f4_bill_dxfile(dxfile_data, &Xshell.adapter.lead);
		}
	    }
	}

	if (lxport_data->link_z.call) {
	    Xshell.cleanup.back = lxport_data->link_z.back;
	    Xshell.cleanup.call = lxport_data->link_z.call;

	    bits |= X1f4_XSHELL_BACK_MASK | X1f4_XSHELL_CALL_MASK;
	}

	Xshell.command.argv = argv;
	Xshell.command.path =
	    ((struct x1f4_dxdata_type *) xsport_data->path)->string;

	Xshell.printer.head = lxport_data->link_e.line;
	Xshell.printer.look = lxport_data->link_e.data;
	Xshell.printer.tail = lxport_data->link_e.post;
	Xshell.printer.type = lxport_data->link_e.push;

	switch (lxport_data->link_x.c3rd) {
	case LOSE_C3RD:
	    Xshell.trailer.c3rd = X1f4_XSHELL_KILL_C3RD;
	    break;
	case NULL_C3RD:
	    Xshell.trailer.c3rd = X1f4_XSHELL_NULL_C3RD;
	    break;
	default:
	    Xshell.trailer.c3rd = X1f4_XSHELL_MISS_C3RD;
	}

	status = x1f4_mode_xshell(xshell, &Xshell, bits);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	} else {
	    status = x1f4_deck_xshell(xshell);
	    if (status) {
		status = _libx1f4i0_lxport_stat_xsxx(lxport_data);
	    } else {
		int excess, fd_0, fd_1;
		unsigned part;
		void *lxfile;

		x1f4_hook_xshell(xshell, &xsport_data->waitlink.port);

		x1f4_pipe_xshell(xshell, &fd_0, &fd_1);

		lxfile = lxport_data->link_l.file;

		part = xsport_data->bits;

		dxfile_data = xsport_data->line;
		if (dxfile_data->file) {
		    status = x1f4_lose_dxfile
			(lxport_data->link_l.file, dxfile_data);
		    if (status) {
			status = X1f4_EX_CRITICAL;
		    }
		}
		if (bits & X1f4_XSHELL_LIFT_MASK) {
		} else {
		    if (part & READ_LOCK) {
			excess = lock_port(lxport_data, fd_0);
			if (excess) {
			    status = excess;
			}
		    }

		    excess = x1f4_pick_dxfile(lxfile, dxfile_data, fd_0);
		    if (excess) {
			status = X1f4_EX_CRITICAL;
		    }
		}

		dxfile_data = xsport_data->text;
		if (dxfile_data->file) {
		    excess = x1f4_lose_dxfile
			(lxport_data->link_l.file, dxfile_data);
		    if (excess) {
			status = X1f4_EX_CRITICAL;
		    }
		}
		if (bits & X1f4_XSHELL_LEAD_MASK) {
		} else {
		    unsigned call = 0;

		    if (part & SEND_LOCK) {
			excess = lock_port(lxport_data, fd_1);
			if (excess) {
			    status = excess;
			} else {
			    call = X1f4_LXFILE_POSH_BLOCK;
			}
		    }

		    excess = x1f4_posh_dxfile
			(lxfile, dxfile_data, fd_1, call);
		    if (excess) {
			status = X1f4_EX_CRITICAL;
		    }
		}
	    }
	}

	excess = x1f4_fini_xshell(&xshell);
	if (excess) {
	    if (status) {
	    } else {
		status = X1f4_EX_CRITICAL;
	    }
	}
    }

    return status;
}


static int
lock_port(struct lxport_type *lxport_data, int fd)
{
    int flags, status;

    flags = fcntl(fd, F_GETFL, 0);
    if (flags < 0) {
	status = _libx1f4i0_lxport_stat_call
	    (lxport_data, "get status flags", 16);
    } else {
	status = fcntl(fd, F_SETFL, flags | O_NONBLOCK);
	if (status) {
	    status = _libx1f4i0_lxport_stat_call
		(lxport_data, "set status flags", 16);
	}
    }

    return status;
}


static int
slip_port(struct lxport_type *lxport_data, struct xsport_type *xsport_data)
{
    int status;
    struct x1f4_dxlist_type *dxlist_data;
    unsigned size;
    void *text;

    dxlist_data = xsport_data->argv;

    size = dxlist_data->size;

    status = lxport_data->link_m.link
	(lxport_data->link_m.data, &text, (size + 1) * sizeof(char *));
    if (status) {
	status = _libx1f4i0_lxport_stat_link(lxport_data);
    } else {
	int excess;
	struct land_type land;

	land.argv = text;
	land.data = lxport_data->link_i.data;

	status = _libx1f4i0_lime_l4list
	    (dxlist_data->list, &land, type_list);
	if (status) {
	    status = _libx1f4i0_lxport_stat_text(lxport_data);
	} else {
	    *land.argv = NULL;

	    if (0) {
	    } else {
		status = link_port(lxport_data, xsport_data, text);
		if (status) {
		} else {
		}
	    }
	}

	excess = lxport_data->link_m.free(lxport_data->link_m.data, text);
	if (excess) {
	    if (status) {
	    } else {
		status = _libx1f4i0_lxport_stat_free(lxport_data);
	    }
	}
    }

    return status;
}


static int
type_list(void *text, void *data)
{
    int delete;
    struct land_type *land_data;
    unsigned type;

    land_data = text;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];
    if (type == X1f4_E4_TEXT) {
	const char **argv;

	argv = land_data->argv;

	*argv = I_TEXT(byte(data) + 8);

	land_data->argv = argv + 1;

	delete = 0;
    } else {
	if (type == land_data->data) {
	    const char **argv;

	    argv = land_data->argv;

	    *argv =
		((struct x1f4_dxdata_type *) I_DATA(byte(data) + 8))->string;

	    land_data->argv = argv + 1;

	    delete = 0;
	} else {
	    delete = 1;
	}
    }

    return delete;
}


int
_libx1f4i0_lxport_l_1xshell(void *context, void *output, void **input)
{
    int status;
    struct lxport_type *lxport_data;
    struct xsport_type *xsport_data;

    lxport_data = context;

    xsport_data = I_PORT(input[0]);

    do {
	if (1) {
	    if (xsport_data->waitlink.port ^ -1) {
		status = _libx1f4i0_lxport_stat_live(lxport_data, xsport_data);
		if (1) {
		    break;
		}
	    }
	}

	if (1) {
	    struct x1f4_dxlist_type *dxlist_data;

	    dxlist_data = xsport_data->argv;
	    if (dxlist_data->size) {
	    } else {
		status = _libx1f4i0_lxport_stat_null(lxport_data);
		if (1) {
		    break;
		}
	    }
	}

	if (1) {
	    struct x1f4_dxfile_type *dxfile_data;

	    dxfile_data = xsport_data->note;
	    if (dxfile_data) {
		if (dxfile_data->file) {
		    if (dxfile_data->mode ^ X1f4_LXFILE_PUSH_CLASS) {
			status = _libx1f4i0_lxport_stat_push(lxport_data);
			if (1) {
			    break;
			}
		    }

		    if (1) {
			int fd;

			if (x1f4_bill_dxfile(dxfile_data, &fd)) {
			    status = _libx1f4i0_lxport_stat_push(lxport_data);
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }

	    dxfile_data = xsport_data->side;
	    if (dxfile_data) {
		if (dxfile_data->file) {
		    if (dxfile_data->mode ^ X1f4_LXFILE_READ_CLASS) {
			status = _libx1f4i0_lxport_stat_read(lxport_data);
			if (1) {
			    break;
			}
		    }

		    if (1) {
			int fd;

			if (x1f4_bill_dxfile(dxfile_data, &fd)) {
			    status = _libx1f4i0_lxport_stat_read(lxport_data);
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	}

	status = slip_port(lxport_data, xsport_data);
    } while (0);

    return status;
}
