/*
 * lxwide.h
 * Copyright (C) 2010-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxwide_H__
#define __LIBx1f4_lxwide_H__

#include <e4.h>
#include <frame.h>
#include <nl.h>
#include <nt.h>
#include <trans.h>

#define X1f4_LXWIDE_CASTTYPE		(1L << 0x03)
#define X1f4_LXWIDE_CODELINK		(1L << 0x04)
#define X1f4_LXWIDE_MISSBAIL		(1L << 0x05)
#define X1f4_LXWIDE_RESOURCE		(1L << 0x06)
#define X1f4_LXWIDE_TEXTFLAT		(1L << 0x07)

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

typedef struct x1f4_lxwide_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } widetype_set;
    struct {
	int node;
    } textnode_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct x1f4_frame_type autolink_set;
    struct x1f4_trans_type codelink_set;
} x1f4_lxwide_type;

extern int x1f4_mind_lxwide
    (int *, const struct x1f4_lxwide_type *, const char *, unsigned);

#endif				/* __LIBx1f4_lxwide_H__ */
