/*
 * lxwide-types.h
 * Copyright (C) 2010-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxwide_types_H__
#define __LIBx1f4_lxwide_types_H__

#include <e4.h>
#include <frame.h>
#include <nt.h>
#include <trans.h>

typedef struct lxwide_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } widetype_set;
    struct {
	int node;
    } textnode_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct x1f4_frame_type autolink_set;
} lxwide_type;

#endif				/* __LIBx1f4_lxwide_types_H__ */
