/*
 * lxwide-d.f.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxwide-types.h>

int
x1f4_mind_lxwide(int *type, const struct lxwide_type *lxwide_data,
		 const char *name, unsigned size)
{
    int delete = 0;
    const struct x1f4_nodetype_type *nodetype_data;
    unsigned miss;

    nodetype_data = lxwide_data->datatype_set.nodetype_data;
    miss = lxwide_data->datatype_set.miss;
    for (; miss; miss--) {
	if (size ^ nodetype_data->size) {
	    nodetype_data++;
	} else {
	    if (memcmp(nodetype_data->name, name, size)) {
		nodetype_data++;
	    } else {
		*type = nodetype_data->code;
		delete = 1;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}
