/*
 * lxtrap-types.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxtrap_types_H__
#define __LIBx1f4_lxtrap_types_H__

#include <config.h>

#include <ct.h>
#include <e4.h>
#include <frame.h>
#include <it.h>
#include <track.h>
#include <trans.h>

typedef struct fxmiss_type {
    void *locker, *lxtrap;
} fxmiss_type;

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxtrap_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	void *data;
    } link_f;
    struct {
	struct x1f4_track_type **call;
    } link_h;
    struct x1f4_trans_type link_m;
    struct x1f4_iturn_type link_p;
    struct x1f4_cturn_type link_q;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct x1f4_trans_type link_v;
    struct x1f4_trans_type link_w;
} lxtrap_type;

typedef struct lxtype_type {
    int (*lead) (void *, void **), (*slip) (void *, void **), type;
    void *text;
} lxtype_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	struct x1f4_track_type **call;
    } link_h;
    struct x1f4_trans_type link_m;
    struct {
	void *fine;
    } link_o;
    struct x1f4_iturn_type link_p;
    struct x1f4_cturn_type link_q;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct x1f4_frame_type link_v;
    struct x1f4_trans_type link_w;
} screen_type;

#endif				/* __LIBx1f4_lxtrap_types_H__ */
