/*
 * lxtrap-l.w.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>

int
_libx1f4i0_lxtrap_w_logique(void *context, void *data, void **text)
{
    int status;
    struct lxtrap_type *lxtrap_data;
    struct x1f4_function_type *function_data;
    void *near;

    lxtrap_data = context;

    function_data = data;

    function_data->function = _libx1f4i0_lxtrap_w1logique;

    status = lxtrap_data->link_v.link
	(lxtrap_data->link_v.data, &near, sizeof(void *) << 1);
    if (status) {
	status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
    } else {
	void **side;

	side = near;

	*text = side;

	*side = lxtrap_data;
	side[1] = function_data;
    }

    return status;
}
