/*
 * lxtrap-l.f.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <exerrors.h>
#include <lxtrap-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxtrap_f_logique(void *context, void *data, void **input)
{
    char *text;
    struct lxtrap_type *lxtrap_data;

    lxtrap_data = context;

    text = I_TEXT(input[0]);

    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;

	data = lxtrap_data->link_e.data;

	line = lxtrap_data->link_e.line;
	if (line) {
	    if (line(data)) {
		break;
	    }
	}

	push = lxtrap_data->link_e.push;
	if (push) {
	    if (push(data, text, strlen(text))) {
		break;
	    }
	}

	post = lxtrap_data->link_e.post;
	if (post) {
	    if (post(data)) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CANNOT_CONTINUE;
}
