/*
 * lxtrap-l.c.1.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

extern const void *const x1f4_a1_walk_link;

int
_libx1f4i0_lxtrap_c1logique(void *context, void *output, void **input)
{
    int status;
    struct lxtrap_type *lxtrap_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side, **track;

    side = context;

    lxtrap_data = side[0];

    if (output == x1f4_a1_walk_link) {
	track = input[1];
    } else {
	track = input;
    }

    dxcast_data = I_USER(track[0]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	struct x1f4_linetext_type *linetext_data;

	linetext_data = I_USER(&dxcast_data->data);
	if (linetext_data->function.function) {
	    status = _libx1f4i0_lxcall_post_call
		(linetext_data, side[1], output, 1, input,
		 &lxtrap_data->link_v, &lxtrap_data->link_p,
		 &lxtrap_data->link_q, &lxtrap_data->link_e,
		 lxtrap_data->trap_e.eelookup_data);
	} else {
	    status = _libx1f4i0_lxtrap_stat_null(lxtrap_data, "call", 4);
	}
    } else {
	status = _libx1f4i0_lxtrap_stat_call(lxtrap_data, 0, "call", 4);
    }

    return status;
}
