/*
 * lxtrap-i.t.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <fd.h>
#include <lxcall.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <retain.h>

#if __RETAIN_OBJECT_DATA__
# error data for created objects is not retained, as probably should have been
#endif				/* __RETAIN_OBJECT_DATA__ */

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const struct x1f4_track_type _libx1f4i0_missed_track;

extern const void *const x1f4_a1_walk_link;

static int miss_call(void *, int, void *, struct x1f4_dispatch_type **);
static int pick_call(void *, void **, void **, void **, struct lxtrap_type *,
		     struct x1f4_linetext_type *, int);
static int slip_call(void *, void **, void **, void **, struct lxtrap_type *,
		     struct x1f4_linetext_type *, int);

static int
miss_call(void *text, int status, void *output,
	  struct x1f4_dispatch_type **dispatch)
{
    struct fxmiss_type *fxmiss_data;

    fxmiss_data = text;

    if (fxmiss_data->locker) {
	struct lxtrap_type *lxtrap_data;

	lxtrap_data = fxmiss_data->lxtrap;
	*(struct x1f4_track_type **) lxtrap_data->link_h.call =
	    fxmiss_data->locker;
    }

    if (status == X1f4_EX_CAN_CONTINUE) {
	status = 0;
	l_MODE(-1, output);
    } else {
	l_MODE(status, output);
    }

    *dispatch = NULL;

    return status;
}


static int
pick_call(void *output, void **input, void **track, void **side,
	  struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data, int frame)
{
    int status;

    do {
	struct fxdata_type missed;
	void *deftext;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    status = _libx1f4i0_lxcall_pick_call
		(input, side[1], 1, &lxtrap_data->link_v, &lxtrap_data->link_e,
		 &linetext_data);
	    if (status) {
		if (status == X1f4_EX_CAN_CONTINUE) {
		    status = 0;
		    l_MODE(-1, output);
		} else {
		}

		break;
	    }
	}

	deftext = (void *) linetext_data->context;

	if (frame) {
	    struct x1f4_track_type **trace, *track_data;

	    trace = lxtrap_data->link_h.call;

	    track_data = *trace;

	    *trace = (struct x1f4_track_type *) &_libx1f4i0_missed_track;

	    status = linetext_data->function.function(deftext, &missed, track);

	    *trace = track_data;
	} else {
	    status = linetext_data->function.function(deftext, &missed, track);
	}

	if (status) {
	    if (status == X1f4_EX_CAN_CONTINUE) {
		status = 0;
		l_MODE(-1, output);
	    } else {
	    }
	} else {
	    l_MODE(0, output);
	}
    } while (0);

    return status;
}


static int
slip_call(void *output, void **input, void **track, void **side,
	  struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data, int frame)
{
    int status;

    do {
	unsigned mind;
	void *miss;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    mind = sizeof(struct x1f4_linetext_type);
	    if (linetext_data->function.flags
		& (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
		mind += (((struct x1f4_function_type *) side[1])->count - 1)
		    * sizeof(int) << 1;
	    } else {
		if (linetext_data->function.count) {
		    mind += sizeof(int)
			* (((struct x1f4_function_type *) side[1])->count - 1);
		}
	    }
	} else {
	    mind = 0;
	}

	status = lxtrap_data->link_v.link
	    (lxtrap_data->link_v.data, &miss,
	     sizeof(struct x1f4_dispatch_type) + sizeof(struct fxmiss_type)
	     + sizeof(struct fxdata_type) + mind);
	if (status) {
	    status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
	    break;
	} else {
	    struct fxmiss_type *fxmiss_data;
	    struct x1f4_dispatch_type *dispatch_data;
	    void *subtext;

	    dispatch_data = miss;

	    fxmiss_data = (void *) (dispatch_data + 1);

	    output = input[0];

	    subtext = (void *) linetext_data->context;

	    if (mind) {
		status = _libx1f4i0_lxcall_slip_call
		    (track, side[1], 1, &linetext_data,
		     (void *) ((struct fxdata_type *) (fxmiss_data + 1) + 1),
		     &subtext);
		if (status) {
		    if (status == X1f4_EX_CAN_CONTINUE) {
			status = 0;
			input[2] = NULL;
			l_MODE(-1, output);
		    } else {
		    }

		    break;
		}
	    }

	    fxmiss_data->locker = NULL;
	    fxmiss_data->lxtrap = lxtrap_data;

	    dispatch_data->back = fxmiss_data;
	    dispatch_data->call = miss_call;

	    dispatch_data->transfer.context = subtext;
	    dispatch_data->transfer.function_data = &linetext_data->function;
	    dispatch_data->transfer.input = track;
	    dispatch_data->transfer.output = fxmiss_data + 1;

	    input[2] = dispatch_data;

	    if (frame) {
		*lxtrap_data->link_h.call =
		    (struct x1f4_track_type *) &_libx1f4i0_missed_track;
	    }
	}
    } while (0);

    return status;
}


int
_libx1f4i0_lxtrap_trap_call(void *context, void *output, void **input,
			    int frame)
{
    int linked, status;
    struct lxtrap_type *lxtrap_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side, **track;

    linked = output == x1f4_a1_walk_link;

    side = context;

    lxtrap_data = side[0];

    if (linked) {
	track = input[1];
    } else {
	track = input;
    }

    dxcast_data = I_USER(track[0]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	struct x1f4_linetext_type *linetext_data;
	void *meta;

	linetext_data = I_USER(&dxcast_data->data);

	meta = *(track - 1);

	track++;

	status = _libx1f4i0_lxtrap_even_list
	    (&linetext_data->function, side[1], 1, &track, lxtrap_data);
	if (status) {
	} else {
	    if (linetext_data->function.function) {
		int (*call) (void *, void **, void **, void **,
			     struct lxtrap_type *,
			     struct x1f4_linetext_type *, int);

		if (linked) {
		    call = slip_call;
		} else {
		    call = pick_call;
		}

		track[-1] = meta;

		status = call
		    (output, input, track, side, lxtrap_data, linetext_data,
		     frame);
	    } else {
		status = _libx1f4i0_lxtrap_stat_null(lxtrap_data, "trap", 4);
	    }
	}
    } else {
	status = _libx1f4i0_lxtrap_stat_call(lxtrap_data, 0, "trap", 4);
    }

    return status;
}
