/*
 * lxtrap-e.4.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <trans.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxtrap_lead_text(void *subtext, void **address)
{
    int status;
    const void *text;

    text = *address;

    if (text == x1f4_c1_empty_string) {
	status = 0;
    } else {
	unsigned size;

	size = strlen(text);

	if (size) {
	    struct lxtrap_type *lxtrap_data;

	    lxtrap_data = subtext;

	    size++;

	    status = lxtrap_data->link_m.link
		(lxtrap_data->link_m.data, address, size);
	    if (status) {
		status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
	    } else {
		memcpy(*address, text, size);
	    }
	} else {
	    *address = (char *) x1f4_c1_empty_string;

	    status = 0;
	}
    }

    return status;
}
