/*
 * lxtrap-a.e.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <er.h>
#include <exerrors.h>
#include <lxtrap-types.h>

#define lxtrap(lxtrap) \
    ((struct lxtrap_type *) (lxtrap))

int
_libx1f4i0_lxtrap_stat_call(void *lxtrap, int rank, const char *call,
			    unsigned size)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("non function pointer ", 21);
    PUSH_MODE(rank + 1);
    PUSH_RANK(rank);
    PUSH_DATA(" argument for function `", 24);
    PUSH_DATA(call, size);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_cast(void *lxtrap)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("will not set data of the `object' type", 38);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_free(void *lxtrap)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtrap_stat_link(void *lxtrap)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtrap_stat_miss(void *lxtrap, int first, int second)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("unmatched output types (store is ", 33);
    PUSH_TRAP(first, lxtrap(lxtrap));
    PUSH_DATA(", result is ", 12);
    PUSH_TRAP(second, lxtrap(lxtrap));
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_null(void *lxtrap, const char *call, unsigned size)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA(call, size);
    PUSH_DATA(": null function pointer", 23);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_post(void *lxtrap, int first, int second)
{
    LINE_EEER(lxtrap(lxtrap)->link_e);

    PUSH_DATA("unmatched output types (store is ", 33);
    PUSH_TRAP(first, lxtrap(lxtrap));
    PUSH_DATA(", function is ", 14);
    PUSH_TRAP(second, lxtrap(lxtrap));
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
