/*
 * lxtime-l.d.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <time.h>

#include <e4.h>
#include <lxdate-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TIME(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxtime_d_logique(void *context, void *output, void **input)
{
    struct dxdate_type *dxhead_data, *dxleft_data;
    struct dxtime_type *dxtime_data;
    unsigned second_a, second_f, second_l;

    dxtime_data = I_TIME(input[0]);

    dxhead_data = I_DATE(input[1]);
    dxleft_data = I_DATE(input[2]);

    if (dxhead_data->time < dxleft_data->time) {
	second_a = dxleft_data->time - dxhead_data->time;
	second_l = 1 << 17;
	if (dxhead_data->second_f < dxleft_data->second_f) {
	    second_f = dxleft_data->second_f - dxhead_data->second_f;
	} else {
	    second_a--;
	    second_f = dxleft_data->second_f + 1000000 - dxhead_data->second_f;
	}
    } else {
	if (dxleft_data->time < dxhead_data->time) {
	    second_a = dxhead_data->time - dxleft_data->time;
	    second_l = 0;
	    if (dxleft_data->second_f < dxhead_data->second_f) {
		second_f = dxhead_data->second_f - dxleft_data->second_f;
	    } else {
		second_a--;
		second_f = dxhead_data->second_f + 1000000
		    - dxleft_data->second_f;
	    }
	} else {
	    if (dxhead_data->second_f < dxleft_data->second_f) {
		second_a = 0;
		second_f = dxleft_data->second_f - dxhead_data->second_f;
		second_l = 1 << 17;
	    } else {
		if (dxleft_data->second_f < dxhead_data->second_f) {
		    second_a = 0;
		    second_f = dxhead_data->second_f - dxleft_data->second_f;
		    second_l = 0;
		} else {
		    second_a = 0;
		    second_f = 0;
		    second_l = 0;
		}
	    }
	}
    }

    dxtime_data->second_a = second_a;
    dxtime_data->second_f = second_f;
    dxtime_data->second_l = second_a % 60 | second_a / 60 % 60 << 6
	| second_a / 3600 % 24 << 12 | second_l
	| second_f * 60 / 1000000 << 18;

    return 0;
}
