/*
 * lxtime-e.w.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdate-inter.h>
#include <lxdate-types.h>

int
x1f4_slip_lxtime(void *subtext, void **data)
{
    int status;
    struct dxtime_type *dxtime_data;
    unsigned call;

    dxtime_data = *data;

    call = dxtime_data->call;
    call--;
    if (call) {
	dxtime_data->call = call;

	status = 0;
    } else {
	status = _libx1f4i0_lxdate_side_time(subtext, dxtime_data);
    }

    return status;
}
