/*
 * lxtext-types.h
 * Copyright (C) 2008-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxtext_types_H__
#define __LIBx1f4_lxtext_types_H__

#include <config.h>

#include <frame.h>
#include <track.h>
#include <trans.h>

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxtext_type {
    struct x1f4_track_type link_e;
    struct {
	void *data, *side;
    } link_f;
    struct x1f4_trans_type link_m;
    struct x1f4_frame_type link_v;
    struct x1f4_trans_type link_w;
} lxtext_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct x1f4_trans_type link_m;
    struct x1f4_frame_type link_v;
    struct x1f4_trans_type link_w;
} screen_type;

#endif				/* __LIBx1f4_lxtext_types_H__ */
