/*
 * lxtext-e.5.c
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxtext_i140306_0(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE head, tail;
	char *text;
	struct lxtext_type *lxtext_data;
	unsigned rate, size;

	text = I_TEXT(input[0]);

	size = strlen(text);

	head = I_MODE(input[1]);
	tail = I_MODE(input[2]);

	if (head < 0) {
	    head = -head;
	    if (size < head) {
		l_TEXT(text, output);
		status = 0;
		break;
	    } else {
		head = size - head;
	    }
	} else {
	    if (head < size) {
	    } else {
		l_TEXT(text, output);
		status = 0;
		break;
	    }
	}

	if (tail < 0) {
	    tail = -tail;
	    if (size < tail) {
		l_TEXT(text, output);
		status = 0;
		break;
	    } else {
		tail = size - tail;
	    }
	} else {
	    if (tail < size) {
	    } else {
		l_TEXT(text, output);
		status = 0;
		break;
	    }
	}

	if (tail < head) {
	    rate = head - 1 - tail;
	} else {
	    rate = size + head - 1 - tail;
	}

	lxtext_data = context;

	if (rate) {
	    void *miss;

	    status = lxtext_data->link_v.link
		(lxtext_data->link_v.data, &miss, rate + 1);
	    if (status) {
		status = _libx1f4i0_lxtext_stat_link(lxtext_data);
	    } else {
		char *slip;

		l_TEXT(miss, output);

		slip = miss;

		if (tail < head) {
		    memcpy(slip, text + tail + 1, rate);
		} else {
		    memcpy(slip, text, head);
		    memcpy(slip + head, text + tail + 1, size - 1 - tail);
		}

		slip[rate] = 0;
	    }
	} else {
	    status = 0;

	    l_TEXT((char *) x1f4_c1_empty_string, output);
	}
    } while (0);

    return status;
}
