/*
 * lxtext-e.4.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>

#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <lcardinal-w.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i101214_0(void *context, void *output, void **input)
{
    int status;
    unsigned long class;

    status = x1f4_parse_wlcardinal(&class, I_TEXT(input[0]), NULL, 10);
    if (status) {
	status = _libx1f4i0_lxtext_stat_line
	    (context, "aton", I_TEXT(input[0]));
    } else {
	l_BILL(class, output);
    }

    return status;
}
