/*
 * lxtext-c.9.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <lcardinal.n-fb.h>
# include <lcardinal.p-fb.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i101218_0(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE b;
    int status;

    b = I_MODE(input[0]);
    if (b < 0) {
	status = 1;
    } else {
	X1f4_E4_C_MODE f;

	f = I_MODE(input[1]);
	if (f < 0) {
	    status = 1;
	} else {
	    X1f4_E4_C_MODE x;

	    x = I_MODE(input[2]);
	    if (x < 2) {
		status = 1;
	    } else {
		if (36 < x) {
		    status = 1;
		} else {
		    X1f4_E4_C_BILL c;
		    struct lxtext_type *lxtext_data;
		    unsigned size = 0;
		    void *text;

		    c = I_BILL(input[3]);

		    lxtext_data = context;

		    x1f4_nprint_fblcardinal(&size, f, b, x, c);
		    status = lxtext_data->link_v.link
			(lxtext_data->link_v.data, &text, size + 1);
		    if (status) {
			status = _libx1f4i0_lxtext_stat_link(lxtext_data);
		    } else {
			char *miss;

			miss = (char *) text + size;
			*miss = 0;
			x1f4_xprint_fblcardinal(&miss, 0, f, b, x, c);

			l_TEXT(miss, output);
		    }
		}
	    }
	}
    }

    return status;
}
