/*
 * lxtext-c.7.c
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxtext_i081113_2(void *context, void *output, void **input)
{
    char *text;
    int head, status, tail;
    unsigned size;

    text = I_TEXT(input[0]);
    head = I_MODE(input[1]);
    tail = I_MODE(input[2]);

    size = strlen(text);

    do {
	unsigned deck;

	if (tail < 0) {
	    tail = 0;
	} else {
	    if (head + tail < 0) {
		tail = 0;
	    } else {
		if (head < 0) {
		    tail += head;
		    head = 0;
		    if (size < tail) {
			tail = size;
		    }
		} else {
		    if (head < size) {
			if (size < head + tail) {
			    tail = size - head;
			}
		    } else {
			tail = 0;
		    }
		}
	    }
	}

	deck = tail;

	if (deck == size) {
	    l_TEXT(text, output);
	    status = 0;
	    break;
	}

	if (!deck) {
	    l_TEXT((char *) x1f4_c1_empty_string, output);

	    status = 0;
	} else {
	    struct lxtext_type *lxtext_data;
	    void *miss;

	    lxtext_data = context;

	    status = lxtext_data->link_v.link
		(lxtext_data->link_v.data, &miss, deck + 1);
	    if (status) {
		status = _libx1f4i0_lxtext_stat_link(lxtext_data);
	    } else {
		char *sail;

		l_TEXT(miss, output);

		sail = miss;

		sail[deck] = 0;
		if (deck) {
		    memcpy(sail, text + head, deck);
		}
	    }
	}
    } while (0);

    return status;
}
