/*
 * lxtext-a.e.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <er.h>
#include <exerrors.h>
#include <lxtext-types.h>

#define lxtext(lxtext) \
    ((struct lxtext_type *) (lxtext))

int
_libx1f4i0_lxtext_stat_base(void *lxtext, long base)
{
    LINE_EEER(lxtext(lxtext)->link_e);

    PUSH_DATA("out of range base specification (", 33);
    PUSH_LONG(base);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtext_stat_free(void *lxtext)
{
    LINE_EEER(lxtext(lxtext)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtext_stat_line(void *lxtext, const char *call, const char *dieu)
{
    LINE_EEER(lxtext(lxtext)->link_e);

    PUSH_TEXT(call);
    PUSH_DATA(": cannot parse `", 16);
    PUSH_TEXT(dieu);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtext_stat_link(void *lxtext)
{
    LINE_EEER(lxtext(lxtext)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtext_stat_mode(void *lxtext)
{
    LINE_EEER(lxtext(lxtext)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}
