/*
 * lxssxx-e.d.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <cl.h>
#include <lxdata.h>
#include <lxdate.h>
#include <lxfset.h>
#include <lxlist.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <nt.h>
#include <trans.h>

#define lxport(port) \
    ((struct lxport_type *) (port))
#define ssport(port) \
    ((struct ssport_type *) (port))

int
x1f4_pull_ssport(void *subtext, void *bqpp, void *ssport,
		 const void *port, struct trans_type *trans_data,
		 struct x1f4_caselink_type **caselink)
{
    int status;

    status = x1f4_even_lxtime
	(lxport(subtext)->link_l.date, bqpp, ssport(ssport)->wait,
	 ssport(port)->wait);
    if (status) {
    } else {
	status = x1f4_even_lxdata
	    (lxport(subtext)->link_l.date, bqpp, ssport(ssport)->path,
	     ssport(port)->path);
	if (status) {
	} else {
	    status = x1f4_even_lxdata
		(lxport(subtext)->link_l.date, bqpp,
		 ssport(ssport)->read, ssport(port)->read);
	    if (status) {
	    } else {
		void *list, *record;

		list = ssport(port)->argv;

		status = x1f4_post_lxfset(bqpp, &list, &record);
		if (status) {
		    if (status == X1f4_BQFSET_EVER_MATCH) {
			struct x1f4_nodelink_type *nodelink_data;
			void *lxlist, *miss;

			lxlist = lxport(subtext)->link_l.list;

			nodelink_data = lock_excase(ssport);

			record = ((void **) record)[1];

			status = x1f4_node_lxlist
			    (lxlist, &miss, record, nodelink_data);
			if (status) {
			} else {
			    status = x1f4_free_lxlist
				(lxlist, ssport(ssport)->argv, NULL,
				 nodelink_data);
			    if (status) {
			    } else {
				ssport(ssport)->argv = record;
			    }
			}
		    }
		} else {
		    void *dxlist, **node, *pull;

		    dxlist = ssport(ssport)->argv;

		    node = record;
		    node[0] = list;
		    node[1] = dxlist;

		    status = trans_data->link
			(trans_data->data, &pull,
			 sizeof(struct x1f4_caselink_type)
			 + sizeof(struct x1f4_nodetype_type));
		    if (status) {
			status = _libx1f4i0_lxport_stat_link(subtext);
		    } else {
			struct x1f4_caselink_type *caselink_data;
			struct x1f4_nodetype_type *nodetype_data;

			caselink_data = pull;

			caselink_data->caselink_data = *caselink;

			nodetype_data = (void *) (caselink_data + 1);

			x1f4_type_lxlist
			    (nodetype_data, lxport(subtext)->link_i.list);
			nodetype_data->context = lxport(subtext)->link_l.list;

			caselink_data->nodetype_data = nodetype_data;

			caselink_data->data = dxlist;
			caselink_data->text = list;

			*caselink = caselink_data;
		    }
		}
	    }
	}
    }

    return status;
}
