/*
 * lxssxx-e.c.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxlead.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <nl.h>
#include <tcvset.h>

#define lxport(list) \
    ((struct lxport_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_free_ssport(void *subtext, void *ssport,
		 struct x1f4_nodelink_type **nodelink,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    unsigned call;

    call = lock_exlist(ssport)->call;

    if (call) {
	call--;
	if (call) {
	    status = tccase(lock_exlist(ssport)->text)->miss
		(&lock_exlist(ssport)->pset, &lock_exlist(ssport)->text,
		 nodelink_data, (void *) &lxport(subtext)->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		int (*miss) (void *, struct x1f4_nodelink_type **,
			     struct x1f4_nodelink_type *);

		lock_exlist(ssport)->call = call;

		miss = lxport(subtext)->link_r.miss;
		if (miss) {
		    status = miss
			(lxport(subtext)->link_r.text, nodelink,
			 lock_excase(ssport));
		} else {
		    status = x1f4_mind_lxlead(nodelink, ssport);
		}
	    }
	} else {
	    status = _libx1f4i0_lxport_heap_ssxx(subtext, nodelink, ssport);
	}
    } else {
	status = 0;
    }

    return status;
}
