/*
 * lxssxx-a.x.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxcall.h>
#include <lxport-types.h>
#include <nl.h>
#include <tcvset.h>

#define lxport(port) \
    ((struct lxport_type *) (port))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_push_ssport(void *lxport, void **copy, void *port,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;

    status = tccase(lock_exlist(port)->text)->miss
	(&lock_exlist(port)->pset, &lock_exlist(port)->text, nodelink_data,
	 (void *) &((struct lxport_type *) lxport)->link_m);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	status = _libx1f4i0_lxcall_near_node
	    (&lxport(lxport)->link_v, &lxport(lxport)->link_e,
	     lxport(lxport)->link_t.datatype + 0, *copy);
	if (status) {
	} else {
	    *copy = (void *) port;
	}
    }

    return status;
}
