/*
 * lxssxx-a.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdata.h>
#include <lxdate.h>
#include <lxlead.h>
#include <lxlist.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <nl.h>

#define lxport(port) \
    ((struct lxport_type *) (port))
#define ssport(port) \
    ((struct ssport_type *) (port))

int
_libx1f4i0_lxport_null_ssxx(void *lxport,
			    struct x1f4_nodelink_type **nodelink, void *ssport)
{
    int excess, status;

    status = x1f4_flat_lxtime
	(lxport(lxport)->link_l.date, &ssport(ssport)->wait);

    excess = x1f4_flat_lxdata
	(lxport(lxport)->link_l.data, &ssport(ssport)->path);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    excess = x1f4_flat_lxdata
	(lxport(lxport)->link_l.data, &ssport(ssport)->read);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    /*
     * the true container libraries (including lxlist) would do a -pick- here
     * (instead the -free-).  the lxport library can get away with the -free-
     * specifically because the lxlist library will do a -pick- later while
     * completing the x1f4_free_lxlist call.
     */
    excess = x1f4_free_lxlist
	(lxport(lxport)->link_l.list, ssport(ssport)->argv, nodelink,
	 lock_excase(ssport));
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
