/*
 * lxssxx-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdata.h>
#include <lxdate.h>
#include <lxlist.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <tcvset.h>

static int line_s010(struct lxport_type *, struct ssport_type *);
static int line_s030(struct lxport_type *, struct ssport_type *);
static int line_s050(struct lxport_type *, struct ssport_type *);
static int line_s070(struct lxport_type *, struct ssport_type *);

static int
line_s010(struct lxport_type *lxport_data, struct ssport_type *ssport_data)
{
    int status;
    void *wait;

    status = x1f4_line_lxtime(lxport_data->link_l.date, &wait);
    if (status) {
    } else {
	if (0) {
	    x1f4_flat_lxtime(lxport_data->link_l.date, &wait);
	} else {
	    struct x1f4_dxtime_type *dxtime_data;

	    ssport_data->wait = wait;

	    dxtime_data = wait;

	    dxtime_data->second_a = 0;
	    dxtime_data->second_f = 0;
	}
    }

    return status;
}


static int
line_s030(struct lxport_type *lxport_data, struct ssport_type *ssport_data)
{
    int status;
    void *path;

    status = x1f4_line_lxdata(lxport_data->link_l.data, &path);
    if (status) {
    } else {
	status = line_s010(lxport_data, ssport_data);
	if (status) {
	    x1f4_flat_lxdata(lxport_data->link_l.data, &path);
	} else {
	    ssport_data->path = path;
	}
    }

    return status;
}


static int
line_s050(struct lxport_type *lxport_data, struct ssport_type *ssport_data)
{
    int status;
    void *read;

    status = x1f4_line_lxdata(lxport_data->link_l.data, &read);
    if (status) {
    } else {
	status = line_s030(lxport_data, ssport_data);
	if (status) {
	    x1f4_flat_lxdata(lxport_data->link_l.data, &read);
	} else {
	    ssport_data->read = read;
	}
    }

    return status;
}


static int
line_s070(struct lxport_type *lxport_data, struct ssport_type *ssport_data)
{
    int status;
    void *argv;

    status = x1f4_post_lxlist
	(lxport_data->link_l.list, &argv, lock_excase(ssport_data));
    if (status) {
    } else {
	status = line_s050(lxport_data, ssport_data);
	if (status) {
	    x1f4_free_lxlist
		(lxport_data->link_l.list, argv, NULL,
		 lock_excase(ssport_data));
	} else {
	    ssport_data->argv = argv;
	}
    }

    return status;
}


int
x1f4_line_ssport(void *subtext, void **address)
{
    int status;
    struct lxport_type *lxport_data;
    void *ssport;

    lxport_data = subtext;

    status = lxport_data->link_m.link
	(lxport_data->link_m.data, &ssport, __struct_ssport_type_alloc_size__);
    if (status) {
	status = _libx1f4i0_lxport_stat_link(lxport_data);
    } else {
	ssport = pick_dxlist(ssport);

	status = line_s070(lxport_data, ssport);
	if (status) {
	    lxport_data->link_m.free
		(lxport_data->link_m.data, lock_cxlist(ssport));
	} else {
	    lock_excase(ssport)->nodetype_data =
		lxport_data->link_s.nodetype + 0;

	    lock_excase(ssport)->slip = NULL;

	    lock_exlist(ssport)->call = 1;

	    _libx1f4i0_init_tcvset
		(&lock_exlist(ssport)->pset, &lock_exlist(ssport)->text);

	    *address = ssport;
	}
    }

    return status;
}
