/*
 * lxport-e.t.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dt.h>
#include <lxport-inter.h>

#define lxport(port) \
    ((struct lxport_type *) (port))

int
x1f4_jack_lxport(void *lxport, const struct x1f4_datatype_type *datatype_data)
{
    const char *name;

    name = datatype_data->name;
    while (name) {
	if (datatype_data->size == 4) {
	    int a, b, c, d;

	    a = name[0];
	    b = name[1];
	    c = name[2];
	    d = name[3];

	    if (a == 'd') {
		if (b == 'a' && c == 't') {
		    if (d == 'a') {
			lxport(lxport)->link_l.data = datatype_data->context;
		    } else {
			if (d == 'e') {
			    lxport(lxport)->link_l.date =
				datatype_data->context;
			}
		    }
		}
	    } else {
		if (a == 'f') {
		    if (b == 'i' && c == 'l' && d == 'e') {
			lxport(lxport)->link_l.file = datatype_data->context;
		    }
		} else {
		    if (a == 'l') {
			if (b == 'i' && c == 's' && d == 't') {
			    lxport(lxport)->link_l.list =
				datatype_data->context;
			}
		    }
		}
	    }
	}

	datatype_data++;

	name = datatype_data->name;
    }

    return 0;
}
